/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network;

import com.ibm.hwmca.base.settings.network.FirewallAdmin;
import com.ibm.hwmca.base.settings.network.FirewallAdminException;
import com.ibm.hwmca.base.settings.network.NetAppFirewallRule;
import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.base.settings.network.NetworkInterfaceInformation;
import com.ibm.hwmca.base.settings.network.config.DHCPServerRangeConfig;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.settings.network.NetworkSettingsChangedEvent;
import com.ibm.hwmca.fw.settings.network.NetworkSettingsChangedManager;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class NetworkSettings
implements PersistentData,
Persistable {
    private static String DIRECTORY = "/etc/sysconfig/network-scripts/";
    private static final String MCP_DIRECTORY = "/etc/sysconfig/network/";
    private static final String PREFIX = "ifcfg-";
    private static String NETWORK_FILE = "/etc/sysconfig/network";
    private static final String MCP_NETWORK_FILE = "/etc/sysconfig/network/routes";
    private static String NETWORK_DIR = "etc";
    private static final String MCP_NETWORK_DIR = "sbin";
    private static String STATIC_ROUTES_FILE = "/etc/sysconfig/static-routes";
    private static final String MCP_STATIC_ROUTES_FILE = "/etc/sysconfig/network/routes";
    private static final String ROUTED_FILE = "/etc/sysconfig/routed";
    private static final String ETHERNET_CONFIG_FILE = "/etc/modules.conf";
    private static final String DHCPD_CONF_FILE = "/etc/dhcpd.conf";
    private static final String HOSTS_FILE = "/etc/hosts";
    private static final String DNS_FILE = "/etc/resolv.conf";
    private static final String HOSTNAME = "/etc/HOSTNAME";
    private static final String RUNIFCFGS = "runifcfgs";
    private static final String IFRESET = "ifReset";
    private static final String CATNETWORKFILES = "catNetworkFiles";
    private static final String CPNETWORKFILES = "cpNetworkFiles";
    private static final String SETHOSTNAME = "setHostName";
    private static final String STARTDHCPD = "startDHCPD";
    private static final String STARTROUTED = "startRouted";
    private static final String VERIFYDHCPDCONF = "verifyDhcpdConf";
    private static final File TEMP_DIR = new File("/tmp/");
    private static final String ETHTOOL_PREFIX = "#tg3 /usr/sbin/ethtool -s ";
    private static boolean REDHAT = false;
    private static final String START_BRACKET = "{";
    private static final String END_BRACKET = "}";
    private static File tempDir;
    private static final String TEMP_FILE_PREFIX = "NetDiag";
    private static final String TEMP_PATH_KEY = "tmp";
    private static String ifconfigResults;
    private static String allFileContents;
    private static String networkFileResults;
    private static String staticRoutesFileResults;
    private static String routedFileResults;
    private static String ethernetConfigFileResults;
    private static String dnsFileResults;
    private static String hostsFileResults;
    private static String hostNameResults;
    private static String dhcpdConfResults;
    private static final String persistKey;
    private static final long serialVersionUID = 1L;
    public List networkIfs = new ArrayList();
    public List visibleIfs = new ArrayList();
    public int numLans = 0;
    public boolean someLanIsADHCPServer = false;
    public boolean someLanHasAFixedAddress = false;
    public boolean[] dhcpClient = new boolean[0];
    public String[] devName = new String[0];
    public String[] ipAddr = new String[0];
    public NetworkInfo networkInfo = new NetworkInfo();
    private static String[] SPEEDS;
    public static final int TYPE_UNKNOWN = 1;
    public static final int TYPE_TOKENRING = 1;
    public static final int TYPE_ETHERNET = 2;
    private static NetworkSettings networkSettings;
    private static final String TRACE_MASKT = "XSETNETT";
    private static final String TRACE_MASKF = "XSETNETF";
    private static final String TRACE_MASKD = "XSETNETD";
    private static FrameworkClassLogInfo _logInfo;
    static /* synthetic */ Class class$com$ibm$hwmca$base$settings$network$NetworkSettings;

    private NetworkSettings() {
        Trace.trace(TRACE_MASKT, "-> NetworkSettings constructor");
        String opsys = System.getProperty("os.name");
        Trace.trace(TRACE_MASKT, "opsys = " + opsys);
        if (opsys.substring(0, 5).equals("Linux")) {
            try {
                BufferedReader in = new BufferedReader(new FileReader("/etc/redhat-release"));
                Trace.trace(TRACE_MASKT, "Detected RedHat Linux");
                REDHAT = true;
            }
            catch (FileNotFoundException exc) {
                Trace.trace(TRACE_MASKT, "Detected non-RedHat Linux");
                DIRECTORY = MCP_DIRECTORY;
                NETWORK_FILE = "/etc/sysconfig/network/routes";
                NETWORK_DIR = MCP_NETWORK_DIR;
                STATIC_ROUTES_FILE = "/etc/sysconfig/network/routes";
            }
            this.determineNetworkSettings();
            int i = 0;
            while (i < this.networkIfs.size()) {
                NetworkInterfaceInformation netif = (NetworkInterfaceInformation)this.networkIfs.get(i);
                this.visibleIfs.add(netif);
                ++i;
            }
            Trace.trace(TRACE_MASKT, "NetworkSettings constructor(); visibleIfs.size = " + this.visibleIfs.size());
            this.startDHCPServer();
            this.mergePersistedNetworkSettings();
            this.startRouted();
        }
        Trace.trace(TRACE_MASKT, "<- NetworkSettings constructor");
    }

    public NetworkSettings(PersistentData data) {
        NetworkSettings newData = (NetworkSettings)data;
        this.networkInfo = newData.networkInfo;
        this.networkIfs = newData.networkIfs;
        this.visibleIfs = newData.visibleIfs;
    }

    public boolean isUpgradeData() {
        Trace.trace(TRACE_MASKD, "<> NetworkSettings.isUpgradeData()");
        return true;
    }

    public PersistentData getPersistentData() {
        return this;
    }

    public static NetworkSettings getNetworkSettings() {
        return networkSettings;
    }

    public void applyNetworkSettings(NetworkInfo networkInfo) {
        Trace.trace(TRACE_MASKT, "-> NetworkSettings applyNetworkSettings");
        this.setNetworkInfo(networkInfo);
        this.updateConfigFiles();
        NetworkSettingsChangedManager instance = NetworkSettingsChangedManager.getNetworkSettingsChangedManager();
        NetworkSettingsChangedEvent event = new NetworkSettingsChangedEvent(instance, networkSettings.getNetworkInfo(), networkSettings.getNetworkInterfaceInfo());
        instance.notify(event);
        Trace.trace(TRACE_MASKT, "<- NetworkSettings applyNetworkSettings");
    }

    public NetworkInfo getNetworkInfo() {
        Trace.trace(TRACE_MASKT, "<> NetworkSettings getNetworkInfo()");
        return this.networkInfo;
    }

    public void setNetworkInfo(NetworkInfo networkInfo) {
        Trace.trace(TRACE_MASKT, "-> NetworkSettings.setNetworkInfo()");
        this.networkInfo = networkInfo;
        try {
            PersistenceManager.getPersistenceManager().write(persistKey, this);
        }
        catch (PersistenceException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKT, "<- NetworkSettings.setNetworkInfo()");
    }

    public List getNetworkInterfaceInfo() {
        Trace.trace(TRACE_MASKT, "<> NetworkSettings getNetworkInterfaceInfo()");
        return this.networkIfs;
    }

    public void setNetworkInterfaceInfo(List networkIfs) {
        Trace.trace(TRACE_MASKT, "-> NetworkSettings.setNetworkInterfaceInfo()");
        this.networkIfs = networkIfs;
        try {
            PersistenceManager.getPersistenceManager().write(persistKey, this);
        }
        catch (PersistenceException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKT, "<- NetworkSettings.setNetworkInterfaceInfo()");
    }

    public List getVisibleIfs() {
        Trace.trace(TRACE_MASKT, "<> NetworkSettings getVisibleIfs(); size = " + this.visibleIfs.size());
        return this.visibleIfs;
    }

    public void setVisibleIfs(List visibleIfs) {
        Trace.trace(TRACE_MASKT, "<> NetworkSettings setVisibleIfs(); size = " + visibleIfs.size());
        this.visibleIfs = visibleIfs;
    }

    public void updateConfigFiles() {
        Trace.trace(TRACE_MASKT, "-> NetworkSettings.updateConfigFiles()");
        this.numLans = this.networkIfs.size();
        int numVisibleLans = this.visibleIfs.size();
        int numDHCPServers = 0;
        this.ipAddr = new String[this.numLans];
        this.devName = new String[this.numLans];
        boolean[] visibleLans = new boolean[this.numLans];
        this.dhcpClient = new boolean[this.numLans];
        boolean[] dhcpServer = new boolean[this.numLans];
        Trace.trace(TRACE_MASKT, "numLans = " + this.numLans + "; numVisibleLans = " + numVisibleLans);
        int j = 0;
        String vLanName = "";
        if (numVisibleLans > 0) {
            NetworkInterfaceInformation vNetif = (NetworkInterfaceInformation)this.visibleIfs.get(j);
            vLanName = vNetif.getIfname();
        }
        if (this.numLans > 0) {
            int i = 0;
            while (i < this.numLans) {
                NetworkInterfaceInformation netif = (NetworkInterfaceInformation)this.networkIfs.get(i);
                this.ipAddr[i] = netif.getIpAddr();
                this.devName[i] = netif.getIfname();
                if (this.devName[i].equals(vLanName)) {
                    visibleLans[i] = true;
                    if (++j < numVisibleLans) {
                        NetworkInterfaceInformation vNetif = (NetworkInterfaceInformation)this.visibleIfs.get(j);
                        vLanName = vNetif.getIfname();
                    }
                } else {
                    visibleLans[i] = false;
                }
                this.dhcpClient[i] = netif.isDhcpClient();
                if (!this.dhcpClient[i] && !this.ipAddr[i].equals("0.0.0.0")) {
                    this.someLanHasAFixedAddress = true;
                }
                dhcpServer[i] = netif.isDhcpServer();
                if (dhcpServer[i]) {
                    this.someLanIsADHCPServer = true;
                    ++numDHCPServers;
                }
                Trace.trace(TRACE_MASKT, "netif[" + i + "]: " + this.ipAddr[i] + "; " + this.devName[i] + "; dhcpClient = " + this.dhcpClient[i] + "; dhcpServer = " + dhcpServer[i] + "; isPrivateIf = " + netif.isPrivateIf() + "; visibleLans[" + i + "] = " + visibleLans[i]);
                ++i;
            }
            Trace.trace(TRACE_MASKT, "numDHCPServers = " + numDHCPServers);
        }
        String opsys = System.getProperty("os.name");
        Trace.trace(TRACE_MASKT, "opsys = " + opsys);
        if (!opsys.substring(0, 5).equals("Linux")) {
            Trace.trace(TRACE_MASKT, "WINDOWS!!");
        } else {
            StringWriter sw;
            String hostName;
            String gatewayDev;
            String filebuf;
            Trace.trace(TRACE_MASKT, "LINUX!");
            Exception lastCaught = null;
            StringBuffer copyCommands = new StringBuffer();
            ArrayList filesToCopy = new ArrayList();
            ArrayList filesToDelete = new ArrayList();
            ArrayList<String> fileNames = new ArrayList<String>();
            String[] ifcfgFileNames = new String[this.numLans];
            int trIndex = 0;
            int ethIndex = 0;
            int i = 0;
            while (i < ifcfgFileNames.length) {
                int tmp = ((NetworkInterfaceInformation)this.networkIfs.get(i)).getAdapterType();
                switch (tmp) {
                    case 1: {
                        ifcfgFileNames[i] = DIRECTORY + PREFIX + "tr" + trIndex;
                        ++trIndex;
                        break;
                    }
                    case 2: {
                        ifcfgFileNames[i] = DIRECTORY + PREFIX + "eth" + ethIndex;
                        ++ethIndex;
                        break;
                    }
                    default: {
                        ifcfgFileNames[i] = DIRECTORY + PREFIX + "tr" + trIndex;
                        ++trIndex;
                    }
                }
                fileNames.add(ifcfgFileNames[i]);
                Trace.trace(TRACE_MASKF, "ifcfgFileNames[i] = " + ifcfgFileNames[i]);
                ++i;
            }
            if (!REDHAT) {
                String[] verifyConfParms = new String[]{VERIFYDHCPDCONF, String.valueOf(this.someLanIsADHCPServer)};
                Trace.trace(TRACE_MASKF, "verifyConfParms: " + verifyConfParms[1]);
                String commandResults = this.executeScript(verifyConfParms);
                Trace.trace(TRACE_MASKF, "results of VERIFYDHCPDCONF = [" + commandResults + "]");
            }
            fileNames.add(HOSTS_FILE);
            fileNames.add(ETHERNET_CONFIG_FILE);
            fileNames.add(STATIC_ROUTES_FILE);
            if (REDHAT) {
                fileNames.add(NETWORK_FILE);
                fileNames.add(ROUTED_FILE);
            }
            fileNames.add(DNS_FILE);
            if (!REDHAT) {
                fileNames.add(HOSTNAME);
                if (this.someLanIsADHCPServer) {
                    fileNames.add(DHCPD_CONF_FILE);
                }
            }
            String allFileContents = this.readMultipleFileContents(fileNames);
            Trace.trace(TRACE_MASKF, "Number of Lan Cards found = " + ifcfgFileNames.length);
            int i2 = 0;
            while (i2 < ifcfgFileNames.length) {
                String fname = ifcfgFileNames[i2];
                if (visibleLans[i2]) {
                    try {
                        String filebuf2 = this.getFileContents(fname, allFileContents);
                        StringReader sr = new StringReader(filebuf2);
                        BufferedReader br = new BufferedReader(sr);
                        StringWriter sw2 = new StringWriter(filebuf2.length());
                        String s = null;
                        String ipAddress = "";
                        String networkMask = "";
                        boolean ipUpdated = false;
                        boolean netMaskUpdated = false;
                        boolean gatewayUpdated = false;
                        boolean onbootUpdated = false;
                        boolean bootprotoUpdated = false;
                        boolean mtuUpdated = false;
                        boolean dhcpCSetting = ((NetworkInterfaceInformation)this.networkIfs.get(i2)).isDhcpClient();
                        Trace.trace(TRACE_MASKF, "dhcpCSetting = " + dhcpCSetting);
                        while ((s = br.readLine()) != null) {
                            Trace.trace(TRACE_MASKF, "s = [" + s + "]");
                            s = s.trim();
                            if (-1 != s.indexOf("IPADDR") && -1 == s.indexOf("REMOTE_IPADDR")) {
                                if (dhcpCSetting) continue;
                                ipAddress = ((NetworkInterfaceInformation)this.networkIfs.get(i2)).getIpAddr();
                                s = "IPADDR='" + ipAddress + "'";
                                ipUpdated = true;
                                Trace.trace(TRACE_MASKF, " found IPADDR: " + ipAddress);
                            }
                            if (-1 != s.indexOf("NETMASK")) {
                                if (dhcpCSetting) continue;
                                networkMask = ((NetworkInterfaceInformation)this.networkIfs.get(i2)).getNetMask();
                                s = "NETMASK='" + networkMask + "'";
                                netMaskUpdated = true;
                                Trace.trace(TRACE_MASKF, " found NETMASK: " + networkMask);
                            }
                            if (-1 != s.indexOf("GATEWAY")) {
                                if (!dhcpCSetting) continue;
                                gatewayUpdated = true;
                                Trace.trace(TRACE_MASKF, " found GATEWAY: dhcpCSetting = " + dhcpCSetting);
                            }
                            if (-1 != s.indexOf("ONBOOT")) {
                                s = "ONBOOT=\"yes\"";
                                onbootUpdated = true;
                                Trace.trace(TRACE_MASKF, " found ONBOOT: set it to yes");
                            }
                            if (-1 != s.indexOf("STARTMODE")) {
                                s = "STARTMODE='onboot'";
                                onbootUpdated = true;
                                Trace.trace(TRACE_MASKF, " found STARTMODE: set it to onboot");
                            }
                            if (-1 != s.indexOf("BOOTPROTO")) {
                                Trace.trace(TRACE_MASKF, " found BOOTPROTO: dhcpCSetting = " + dhcpCSetting);
                                bootprotoUpdated = true;
                                s = dhcpCSetting ? "BOOTPROTO='dhcp'" : "BOOTPROTO='static'";
                            }
                            if (-1 != s.indexOf("MTU")) {
                                Trace.trace(TRACE_MASKF, " found MTU ");
                                int mtuValue = this.setMtuValue(s);
                                s = "MTU='" + mtuValue + "'";
                                mtuUpdated = true;
                            }
                            if (!gatewayUpdated) {
                                sw2.write(s);
                                sw2.write("\n");
                                continue;
                            }
                            gatewayUpdated = false;
                        }
                        Trace.trace(TRACE_MASKF, "Loop done, sw = [" + sw2.toString() + "]");
                        if (!ipUpdated && !dhcpCSetting) {
                            ipAddress = ((NetworkInterfaceInformation)this.networkIfs.get(i2)).getIpAddr();
                            s = "IPADDR='" + ipAddress + "'";
                            sw2.write(s);
                            sw2.write("\n");
                        }
                        if (!netMaskUpdated && !dhcpCSetting) {
                            networkMask = ((NetworkInterfaceInformation)this.networkIfs.get(i2)).getNetMask();
                            s = "NETMASK='" + networkMask + "'";
                            sw2.write(s);
                            sw2.write("\n");
                        }
                        if (!onbootUpdated) {
                            s = REDHAT ? "ONBOOT=\"yes\"" : "STARTMODE='onboot'";
                            sw2.write(s);
                            sw2.write("\n");
                        }
                        if (!bootprotoUpdated) {
                            Trace.trace(TRACE_MASKF, "BOOTPROTO missing; add one: dhcpCSetting = " + dhcpCSetting);
                            s = dhcpCSetting ? "BOOTPROTO='dhcp'" : "BOOTPROTO='static'";
                            sw2.write(s);
                            sw2.write("\n");
                        }
                        if (!mtuUpdated) {
                            Trace.trace(TRACE_MASKF, "MTU missing; add default value(1500)");
                            s = "MTU='1500'";
                            sw2.write(s);
                            sw2.write("\n");
                        }
                        sw2.close();
                        this.prepareFileRewrite(fname, sw2.toString(), filebuf2, filesToCopy, filesToDelete);
                    }
                    catch (IOException e) {
                        System.out.println("I/O Exception " + e);
                        lastCaught = e;
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "Lan[" + i2 + "] is hidden - do not update");
                }
                ++i2;
            }
            if (REDHAT) {
                try {
                    filebuf = this.getFileContents(NETWORK_FILE, allFileContents);
                    Trace.trace(TRACE_MASKF, "Reading file: " + NETWORK_FILE);
                    StringReader sr = new StringReader(filebuf);
                    BufferedReader br = new BufferedReader(sr);
                    StringWriter sw3 = new StringWriter(filebuf.length());
                    String s = null;
                    gatewayDev = this.networkInfo.getGatewayDev();
                    hostName = this.networkInfo.getComputerName();
                    String defaultGateway = this.networkInfo.getDefaultGateway();
                    boolean hostUpdated = false;
                    boolean gateUpdated = false;
                    boolean gateDropped = false;
                    boolean gatewayDevUpdated = false;
                    while ((s = br.readLine()) != null) {
                        Trace.trace(TRACE_MASKF, "getFileContents:s = [" + s + "]");
                        if (-1 != s.indexOf("GATEWAYDEV")) {
                            s = "GATEWAYDEV=\"" + gatewayDev + "\"";
                            gatewayDevUpdated = true;
                            Trace.trace(TRACE_MASKF, " found GATEWAYDEV: " + gatewayDev);
                        } else if (-1 != s.indexOf("HOSTNAME")) {
                            String domainName = this.networkInfo.getDomainName();
                            if (!domainName.equals("")) {
                                hostName = hostName + "." + domainName;
                            }
                            s = "HOSTNAME=\"" + hostName + "\"";
                            hostUpdated = true;
                            Trace.trace(TRACE_MASKF, " found HOSTNAME: " + hostName);
                        } else if (-1 != s.indexOf("GATEWAY")) {
                            if (ifcfgFileNames.length == 1 && ((NetworkInterfaceInformation)this.networkIfs.get(0)).isDhcpClient()) {
                                Trace.trace(TRACE_MASKF, " found a GATEWAY, but dropped it");
                                gateDropped = true;
                                this.networkInfo.setDefaultGateway("");
                            } else {
                                s = "GATEWAY=\"" + defaultGateway + "\"";
                                Trace.trace(TRACE_MASKF, " found Default Gateway: " + defaultGateway);
                            }
                            gateUpdated = true;
                        }
                        if (!gateDropped) {
                            sw3.write(s);
                            sw3.write("\n");
                            continue;
                        }
                        gateDropped = false;
                    }
                    if (!hostUpdated && hostName.trim().length() > 0) {
                        s = "HOSTNAME=\"" + hostName + "\"";
                        sw3.write(s);
                        sw3.write("\n");
                        Trace.trace(TRACE_MASKF, " add a new HOSTNAME: " + hostName);
                    }
                    if (!gatewayDevUpdated && gatewayDev.trim().length() > 0) {
                        s = "GATEWAYDEV=\"" + gatewayDev + "\"";
                        sw3.write(s);
                        sw3.write("\n");
                        Trace.trace(TRACE_MASKF, " add a new GATEWAYDEV: " + gatewayDev);
                    }
                    if (!gateUpdated && defaultGateway.trim().length() > 0) {
                        s = "GATEWAY=\"" + defaultGateway + "\"";
                        sw3.write(s);
                        sw3.write("\n");
                        Trace.trace(TRACE_MASKF, " add a new GATEWAY: " + defaultGateway);
                    }
                    sw3.close();
                    this.prepareFileRewrite(NETWORK_FILE, sw3.toString(), filebuf, filesToCopy, filesToDelete);
                }
                catch (IOException e) {
                    System.out.println("I/O Exception " + e);
                    lastCaught = e;
                }
            }
            try {
                filebuf = this.getFileContents(HOSTS_FILE, allFileContents);
                StringTokenizer hostsTokenizer = new StringTokenizer(filebuf, "\n");
                StringWriter sw4 = new StringWriter(filebuf.length());
                String computerName = this.networkInfo.getComputerName().trim();
                String domainName = this.networkInfo.getDomainName().trim();
                gatewayDev = this.networkInfo.getGatewayDev().trim();
                String bothHostNames = hostName = computerName;
                if (domainName.length() > 0) {
                    hostName = hostName + "." + domainName;
                    bothHostNames = hostName + "\t" + computerName;
                }
                Trace.trace(TRACE_MASKF, "hostName = [" + hostName + "]; bothHostNames = [" + bothHostNames + "]");
                boolean gatewayDevFound = false;
                String gatewayDevAddr = "";
                String selectedAdapter = this.networkInfo.getGatewayDev().trim();
                Trace.trace(TRACE_MASKF, "gatewayDev = [" + selectedAdapter + "]");
                if (selectedAdapter.length() > 0 && !selectedAdapter.equals("-")) {
                    gatewayDevFound = true;
                }
                sw4.write("127.0.0.1\tlocalhost.localdomain localhost\n");
                if (gatewayDevFound) {
                    boolean gatewayDevVerified = false;
                    int i3 = 0;
                    while (i3 < this.numLans && !gatewayDevVerified) {
                        if (gatewayDev.equals(this.devName[i3])) {
                            if (this.dhcpClient[i3]) {
                                Trace.trace(TRACE_MASKF, "gatewayDev Found but it's DHCPClient- illegal");
                                this.networkInfo.setGatewayDev(" ");
                            } else {
                                Trace.trace(TRACE_MASKF, "gatewayDev Found and Verified; ipAddr[" + i3 + "] = " + this.ipAddr[i3]);
                                sw4.write(this.ipAddr[i3] + "\t" + bothHostNames + "\n");
                                gatewayDevAddr = this.ipAddr[i3];
                                gatewayDevVerified = true;
                            }
                        }
                        ++i3;
                    }
                    if (!gatewayDevVerified) {
                        Trace.trace(TRACE_MASKF, "gatewayDev not usable; gatewayDev = " + gatewayDev);
                        sw4.write("127.0.0.1\t" + bothHostNames + "\n");
                    }
                } else if (this.someLanHasAFixedAddress) {
                    Trace.trace(TRACE_MASKF, "No gatewaydev defined, but there is at least 1 lan w/fixed address - use first one found");
                    boolean fixedAddrLanFound = false;
                    int i4 = 0;
                    while (i4 < this.numLans && !fixedAddrLanFound) {
                        if (!this.dhcpClient[i4]) {
                            Trace.trace(TRACE_MASKF, "fixed address found; ipAddr[" + i4 + "] = " + this.ipAddr[i4]);
                            sw4.write(this.ipAddr[i4] + "\t" + bothHostNames + "\n");
                            fixedAddrLanFound = true;
                        }
                        ++i4;
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "gatewayDev not found; Use loopback address for hostname");
                    sw4.write("127.0.0.1\t" + bothHostNames + "\n");
                }
                while (hostsTokenizer.hasMoreTokens()) {
                    String line = hostsTokenizer.nextToken().trim();
                    Trace.trace(TRACE_MASKF, "line = [" + line + "]");
                    StringTokenizer lineTokenizer = new StringTokenizer(line);
                    if (lineTokenizer.hasMoreTokens()) {
                        String ipAddress = lineTokenizer.nextToken();
                        Trace.trace(TRACE_MASKF, "ipAddress = [" + ipAddress + "] ; gatewayDevAddr = [" + gatewayDevAddr + "]");
                        if (ipAddress.equals("127.0.0.1") || ipAddress.equals(gatewayDevAddr) || line.indexOf(hostName) != -1) {
                            Trace.trace(TRACE_MASKF, "Drop this line = [" + line + "]");
                            continue;
                        }
                    }
                    sw4.write(line + "\n");
                }
                sw4.close();
                this.prepareFileRewrite(HOSTS_FILE, sw4.toString(), filebuf, filesToCopy, filesToDelete);
            }
            catch (IOException e) {
                System.out.println("I/O Exception " + e);
                lastCaught = e;
            }
            Trace.trace(TRACE_MASKF, "-> DHCPD_CONF_FILE processing");
            NetworkInterfaceInformation netif = null;
            boolean dhcpServersAllHidden = true;
            String[] dhcpServerIfName = new String[numDHCPServers];
            boolean[] dhcpServerVisible = new boolean[numDHCPServers];
            DHCPServerRangeConfig[] dhcpServerConfig = new DHCPServerRangeConfig[numDHCPServers];
            boolean[] previouslyDefined = new boolean[numDHCPServers];
            j = 0;
            int i5 = 0;
            while (i5 < this.numLans) {
                Trace.trace(TRACE_MASKT, "dhcpServer[" + i5 + "] = " + dhcpServer[i5]);
                if (dhcpServer[i5]) {
                    netif = (NetworkInterfaceInformation)this.networkIfs.get(i5);
                    Trace.trace(TRACE_MASKT, "DHCP Server found: networkIfs[" + i5 + "]: " + netif.getIfname());
                    dhcpServerIfName[j] = this.devName[i5];
                    dhcpServerVisible[j] = visibleLans[i5];
                    dhcpServerConfig[j] = netif.getDhcpServerRangeConfig();
                    previouslyDefined[j] = false;
                    Trace.trace(TRACE_MASKT, "visible = " + dhcpServerVisible[j] + "; dhcpServerConfig: " + dhcpServerConfig[j].getHmcAddress() + "; " + dhcpServerConfig[j].getStart() + "; " + dhcpServerConfig[j].getEnd() + "; " + dhcpServerConfig[j].getSubnet() + "; " + dhcpServerConfig[j].getMask());
                    ++j;
                }
                ++i5;
            }
            int i6 = 0;
            while (i6 < this.numLans && dhcpServersAllHidden) {
                if (visibleLans[i6] && dhcpServer[i6]) {
                    dhcpServersAllHidden = false;
                    Trace.trace(TRACE_MASKT, "There is at least one visible DHCP Server - process");
                }
                ++i6;
            }
            String filebuf3 = this.getFileContents(DHCPD_CONF_FILE, allFileContents);
            int foundIndex = 0;
            boolean done = false;
            while (!done) {
                foundIndex = filebuf3.indexOf("# option routers");
                if (foundIndex != -1) {
                    filebuf3 = filebuf3.substring(0, foundIndex) + " " + filebuf3.substring(foundIndex + 1);
                    continue;
                }
                done = true;
            }
            int numCurrentServers = 0;
            ArrayList<String> serverAddressesRemoved = new ArrayList<String>();
            StringTokenizer dhcpdTokenizer = new StringTokenizer(filebuf3, "\n");
            while (dhcpdTokenizer.hasMoreTokens()) {
                String line = dhcpdTokenizer.nextToken().trim();
                if (!line.startsWith("range")) continue;
                ++numCurrentServers;
            }
            Trace.trace(TRACE_MASKF, "Number of DHCPServers now in dhcpd.conf: " + numCurrentServers + "; should have: " + numDHCPServers);
            if (!(numDHCPServers == numCurrentServers && numDHCPServers == 0 || numDHCPServers == numCurrentServers && dhcpServersAllHidden)) {
                try {
                    StringWriter sw5 = new StringWriter(filebuf3.length());
                    dhcpdTokenizer = new StringTokenizer(filebuf3, "\n");
                    String optionRouters = "";
                    String additionalParms = "";
                    String subnet = "";
                    String mask = "";
                    String start = "";
                    String end = "";
                    boolean subnetOpen = false;
                    while (dhcpdTokenizer.hasMoreTokens()) {
                        String parm2;
                        String line = dhcpdTokenizer.nextToken().trim();
                        Trace.trace(TRACE_MASKF, "line = [" + line + "]");
                        StringTokenizer lineTokenizer = new StringTokenizer(line, " \t\n\r\f;");
                        if (!lineTokenizer.hasMoreTokens()) continue;
                        String parm1 = lineTokenizer.nextToken();
                        if (subnetOpen) {
                            if (parm1.equals("option")) {
                                if (!lineTokenizer.hasMoreTokens()) continue;
                                parm2 = lineTokenizer.nextToken();
                                if (parm2.equals("routers")) {
                                    if (!lineTokenizer.hasMoreTokens()) continue;
                                    optionRouters = lineTokenizer.nextToken();
                                    Trace.trace(TRACE_MASKT, "Inside subnet, 'option routers' found: [" + optionRouters + "]");
                                    continue;
                                }
                                additionalParms = additionalParms + "  " + line + "\n";
                                Trace.trace(TRACE_MASKT, "Line contains additiona subnet parms: line = [" + line + "]");
                                continue;
                            }
                            if (!parm1.equals(END_BRACKET)) continue;
                            subnetOpen = false;
                            Trace.trace(TRACE_MASKT, "Subnet done - Process the values.");
                            if (optionRouters.length() > 0) {
                                Trace.trace(TRACE_MASKT, "optionRouters = [" + optionRouters + "]");
                                boolean ipsMatch = false;
                                int i7 = 0;
                                while (i7 < numDHCPServers && !ipsMatch) {
                                    Trace.trace(TRACE_MASKT, "dhcpServerConfig[" + i7 + "].getHmcAddress() = " + dhcpServerConfig[i7].getHmcAddress());
                                    if (optionRouters.equals(dhcpServerConfig[i7].getHmcAddress())) {
                                        subnet = dhcpServerConfig[i7].getSubnet();
                                        mask = dhcpServerConfig[i7].getMask();
                                        start = dhcpServerConfig[i7].getStart();
                                        end = dhcpServerConfig[i7].getEnd();
                                        previouslyDefined[i7] = true;
                                        ipsMatch = true;
                                    }
                                    ++i7;
                                }
                                if (ipsMatch) {
                                    if (subnet.length() <= 0 || mask.length() <= 0 || start.length() <= 0 || end.length() <= 0) continue;
                                    Trace.trace(TRACE_MASKT, "Update values of an existing DHCPServer:");
                                    Trace.trace(TRACE_MASKT, "subnet " + subnet + " netmask " + mask + START_BRACKET + "\n");
                                    Trace.trace(TRACE_MASKT, "# option routers " + optionRouters + ";\n");
                                    Trace.trace(TRACE_MASKT, "  range " + start + " " + end + ";\n");
                                    if (additionalParms.length() > 0) {
                                        Trace.trace(TRACE_MASKT, additionalParms);
                                    }
                                    Trace.trace(TRACE_MASKT, "}\n");
                                    sw5.write("subnet " + subnet + " netmask " + mask + START_BRACKET + "\n");
                                    sw5.write("# option routers " + optionRouters + ";\n");
                                    sw5.write("  range " + start + " " + end + ";\n");
                                    if (additionalParms.length() > 0) {
                                        sw5.write(additionalParms);
                                    }
                                    sw5.write("}\n");
                                    optionRouters = "";
                                    continue;
                                }
                                serverAddressesRemoved.add(optionRouters);
                                optionRouters = "";
                                Trace.trace(TRACE_MASKT, "This one no longer used - delete it");
                                continue;
                            }
                            Trace.trace(TRACE_MASKT, "Error - end of subnet, but no option router known");
                            continue;
                        }
                        if (parm1.equals("option")) {
                            if (!lineTokenizer.hasMoreTokens() || !(parm2 = lineTokenizer.nextToken()).equals("routers") || !lineTokenizer.hasMoreTokens()) continue;
                            optionRouters = lineTokenizer.nextToken();
                            Trace.trace(TRACE_MASKT, "Outside subnet, 'option routers' found:[" + optionRouters + "]");
                            continue;
                        }
                        if (parm1.equals("subnet")) {
                            subnetOpen = true;
                            Trace.trace(TRACE_MASKT, "Begin processing a subnet.");
                            continue;
                        }
                        sw5.write(line + "\n");
                    }
                    int i8 = 0;
                    while (i8 < numDHCPServers) {
                        if (!previouslyDefined[i8]) {
                            optionRouters = dhcpServerConfig[i8].getHmcAddress();
                            subnet = dhcpServerConfig[i8].getSubnet();
                            mask = dhcpServerConfig[i8].getMask();
                            start = dhcpServerConfig[i8].getStart();
                            end = dhcpServerConfig[i8].getEnd();
                            if (subnet != null && mask != null && start != null && end != null && subnet.length() > 0 && mask.length() > 0 && start.length() > 0 && end.length() > 0) {
                                sw5.write("subnet " + subnet + " netmask " + mask + START_BRACKET + "\n");
                                sw5.write("# option routers " + optionRouters + ";\n");
                                sw5.write("  range " + start + " " + end + ";\n");
                                sw5.write("}\n");
                                Trace.trace(TRACE_MASKT, "Create a new DHCPServer:");
                                Trace.trace(TRACE_MASKT, "subnet " + subnet + " netmask " + mask + START_BRACKET + "\n");
                                Trace.trace(TRACE_MASKT, "# option routers " + optionRouters + ";\n");
                                Trace.trace(TRACE_MASKT, "  range " + start + " " + end + ";\n");
                                if (additionalParms.length() > 0) {
                                    Trace.trace(TRACE_MASKT, additionalParms);
                                }
                                Trace.trace(TRACE_MASKT, "}\n");
                            } else {
                                Trace.trace(TRACE_MASKT, "ERROR! A current value is invalid.");
                            }
                        }
                        ++i8;
                    }
                    sw5.close();
                    this.prepareFileRewrite(DHCPD_CONF_FILE, sw5.toString(), filebuf3, filesToCopy, filesToDelete);
                }
                catch (IOException e) {
                    System.out.println("I/O Exception " + e);
                    lastCaught = e;
                }
            } else {
                Trace.trace(TRACE_MASKF, "No (visible) DHCP Servers found - no changes needed.");
            }
            try {
                filebuf3 = this.getFileContents(STATIC_ROUTES_FILE, allFileContents);
                StringWriter sw6 = new StringWriter(filebuf3.length());
                if (!REDHAT) {
                    Trace.trace(TRACE_MASKF, "-> STATIC_ROUTES processing");
                    StringTokenizer routesTokenizer = new StringTokenizer(filebuf3, "\n");
                    boolean defaultFound = false;
                    while (routesTokenizer.hasMoreTokens() && !defaultFound) {
                        String line = routesTokenizer.nextToken().trim();
                        Trace.trace(TRACE_MASKF, "line = [" + line + "]");
                        StringTokenizer lineTokenizer = new StringTokenizer(line);
                        if (!lineTokenizer.hasMoreTokens()) continue;
                        String parm1 = lineTokenizer.nextToken();
                        Trace.trace(TRACE_MASKF, "parm1 = [" + parm1 + "]");
                        if (parm1.equals("default")) {
                            Trace.trace(TRACE_MASKF, "Default gateway found -drop it and create a new one");
                            defaultFound = true;
                            continue;
                        }
                        if (!parm1.startsWith("#")) continue;
                        sw6.write(line + "\n");
                    }
                    if (!defaultFound) {
                        Trace.trace(TRACE_MASKF, "No default gateway found; may need to create one");
                    } else {
                        Trace.trace(TRACE_MASKF, "Update default gateway");
                    }
                    String defaultGateway = this.networkInfo.getDefaultGateway();
                    String gatewayDev2 = this.networkInfo.getGatewayDev();
                    Trace.trace(TRACE_MASKF, "defaultGateway = [" + defaultGateway + "]; gatewayDev = [" + gatewayDev2 + "]");
                    if (defaultGateway.trim().length() > 0) {
                        if (gatewayDev2.trim().length() > 0) {
                            sw6.write("default " + defaultGateway + " - " + gatewayDev2 + "\n");
                        } else {
                            sw6.write("default " + defaultGateway + " - -\n");
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "No default gateway - skip writing this out");
                    }
                    if (!dhcpServersAllHidden || serverAddressesRemoved.size() > 0) {
                        j = 0;
                        int i9 = 0;
                        while (i9 < this.numLans) {
                            Trace.trace(TRACE_MASKF, "dhcpServer[" + i9 + "] = " + dhcpServer[i9] + "; visible = " + visibleLans[i9]);
                            if (dhcpServer[i9] && visibleLans[i9]) {
                                if (j < dhcpServerConfig.length) {
                                    if (dhcpServerConfig[j] != null) {
                                        if (dhcpServerConfig[j].getSubnet() != null && dhcpServerConfig[j].getHmcAddress() != null && dhcpServerConfig[j].getMask() != null) {
                                            Trace.trace(TRACE_MASKF, "Writing line for visible DHCP Server:  [" + dhcpServerConfig[j].getSubnet() + " " + dhcpServerConfig[j].getHmcAddress() + " " + dhcpServerConfig[j].getMask() + " " + dhcpServerIfName[j] + "]");
                                            if (serverAddressesRemoved.size() > 0) {
                                                Trace.trace(TRACE_MASKF, "We've got servers to remove");
                                                i9 = 0;
                                                while (i9 < serverAddressesRemoved.size()) {
                                                    String removeAddress = (String)serverAddressesRemoved.get(i9);
                                                    if (removeAddress.equals(dhcpServerConfig[j].getHmcAddress())) {
                                                        Trace.trace(TRACE_MASKF, "Remove : " + removeAddress);
                                                    } else {
                                                        Trace.trace(TRACE_MASKF, "Don't remove; Write : " + dhcpServerConfig[j].getHmcAddress());
                                                        sw6.write(dhcpServerConfig[j].getSubnet() + " " + dhcpServerConfig[j].getHmcAddress() + " " + dhcpServerConfig[j].getMask() + " " + dhcpServerIfName[j] + "\n");
                                                    }
                                                    ++i9;
                                                }
                                            } else {
                                                Trace.trace(TRACE_MASKF, "Write : " + dhcpServerConfig[j].getHmcAddress());
                                                sw6.write(dhcpServerConfig[j].getSubnet() + " " + dhcpServerConfig[j].getHmcAddress() + " " + dhcpServerConfig[j].getMask() + " " + dhcpServerIfName[j] + "\n");
                                            }
                                        } else {
                                            Trace.trace(TRACE_MASKF, "ERRORS found - skip this one");
                                        }
                                    }
                                    ++j;
                                } else {
                                    Trace.trace(TRACE_MASKF, "j is too big" + j);
                                }
                            } else {
                                Trace.trace(TRACE_MASKF, "Not a visible dhcpserver - don't write");
                            }
                            ++i9;
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "DHCPServers all hidden - ");
                    }
                }
                Vector TTypeVector = this.networkInfo.getTypeVector();
                int numrows = TTypeVector.size();
                Trace.trace(TRACE_MASKT, "TTypeVector.size = [" + numrows + "]");
                if (TTypeVector != null && numrows != 0) {
                    String gateway;
                    int i10;
                    Trace.trace(TRACE_MASKT, "Process " + STATIC_ROUTES_FILE);
                    Trace.trace(TRACE_MASKT, "numrows " + numrows + " REDHAT = " + REDHAT);
                    Vector TDestinationVector = this.networkInfo.getDestinationVector();
                    Vector TGatewayVector = this.networkInfo.getGatewayVector();
                    Vector TSubnetMaskVector = this.networkInfo.getSubnetMaskVector();
                    Vector TInterfaceVector = this.networkInfo.getInterfaceVector();
                    if (REDHAT) {
                        i10 = 0;
                        while (i10 < numrows) {
                            String type = ((String)TTypeVector.get(i10)).toLowerCase();
                            if (type.equals("net")) {
                                sw6.write("any ");
                            }
                            sw6.write(type);
                            sw6.write(" ");
                            sw6.write((String)TDestinationVector.get(i10));
                            String netmask = ((String)TSubnetMaskVector.get(i10)).trim();
                            if (netmask.length() > 0) {
                                sw6.write(" netmask");
                                sw6.write(" ");
                                sw6.write(netmask);
                            }
                            if ((gateway = ((String)TGatewayVector.get(i10)).trim()).length() > 0) {
                                sw6.write(" gw ");
                                sw6.write(gateway);
                            }
                            sw6.write("\n");
                            ++i10;
                        }
                    } else {
                        i10 = 0;
                        while (i10 < numrows) {
                            String type = ((String)TTypeVector.get(i10)).toLowerCase();
                            if (!type.equals("default")) {
                                String destination = ((String)TDestinationVector.get(i10)).trim();
                                gateway = ((String)TGatewayVector.get(i10)).trim();
                                String netmask = ((String)TSubnetMaskVector.get(i10)).trim();
                                String t_interface = ((String)TInterfaceVector.get(i10)).trim();
                                Trace.trace(TRACE_MASKF, " destination = [" + destination + "]; gateway = [" + gateway + "]; netmask = [" + netmask + "]; t_interface = [" + t_interface + "]");
                                boolean dropEntry = false;
                                j = 0;
                                while (j < this.numLans && !dropEntry) {
                                    Trace.trace(TRACE_MASKF, "devName[" + j + "] = " + this.devName[j] + "; dhcpServer[" + j + "] = " + dhcpServer[j] + "; visibleLans[" + j + "] = " + visibleLans[j]);
                                    if (t_interface.equals(this.devName[j])) {
                                        Trace.trace(TRACE_MASKF, "t_interface = devName[j]: " + t_interface + "; dhcpServer[j] = " + dhcpServer[j] + "; visibleLans[j] = " + visibleLans[j]);
                                        if (dhcpServer[j] && visibleLans[j]) {
                                            dropEntry = true;
                                            Trace.trace(TRACE_MASKF, "dropEntry = true");
                                        } else if (serverAddressesRemoved.size() > 0) {
                                            Trace.trace(TRACE_MASKF, "We've got routes to remove");
                                            int k = 0;
                                            while (k < serverAddressesRemoved.size()) {
                                                String removeAddress = (String)serverAddressesRemoved.get(k);
                                                if (removeAddress.equals(gateway)) {
                                                    dropEntry = true;
                                                    Trace.trace(TRACE_MASKF, "Remove : " + removeAddress);
                                                } else {
                                                    Trace.trace(TRACE_MASKF, "Keep this entry.");
                                                }
                                                ++k;
                                            }
                                        } else {
                                            Trace.trace(TRACE_MASKF, "None to remove");
                                        }
                                    }
                                    ++j;
                                }
                                if (dropEntry) {
                                    Trace.trace(TRACE_MASKF, "Drop the old DHCP Server table entry for adapter: " + t_interface);
                                } else {
                                    sw6.write(destination);
                                    String temp = destination;
                                    if (gateway.length() > 0 && !gateway.trim().equals("null")) {
                                        sw6.write(" " + gateway);
                                        temp = temp + " " + gateway;
                                    } else {
                                        sw6.write(" -");
                                        temp = temp + " -";
                                    }
                                    if (netmask.length() > 0 && !netmask.trim().equals("null")) {
                                        sw6.write(" " + netmask);
                                        temp = temp + " " + netmask;
                                    } else {
                                        sw6.write(" -");
                                        temp = temp + " -";
                                    }
                                    if (t_interface.length() > 0 && (t_interface.startsWith("eth") || t_interface.startsWith("tr"))) {
                                        sw6.write(" " + t_interface);
                                        temp = temp + " " + t_interface;
                                    } else {
                                        sw6.write(" -");
                                        temp = temp + " -";
                                    }
                                    sw6.write("\n");
                                    Trace.trace(TRACE_MASKF, "Writing line from vectors for DHCP Server:  [" + temp + "]");
                                }
                            }
                            ++i10;
                        }
                    }
                }
                sw6.close();
                this.prepareFileRewrite(STATIC_ROUTES_FILE, sw6.toString(), filebuf3, filesToCopy, filesToDelete);
            }
            catch (IOException e) {
                System.out.println("I/O Exception " + e);
                lastCaught = e;
            }
            String[] DRIVERS = new String[]{"e100", "eepro100", "e1000", "bcm5700", "tg3"};
            try {
                filebuf3 = this.getFileContents(ETHERNET_CONFIG_FILE, allFileContents);
                StringTokenizer hostsTokenizer = new StringTokenizer(filebuf3, "\n");
                Trace.trace(TRACE_MASKF, "-> ETHERNET_CONFIG_FILE processing");
                StringReader sr = new StringReader(filebuf3);
                BufferedReader br = new BufferedReader(sr);
                StringWriter sw7 = new StringWriter(filebuf3.length());
                String[] ethDriver = new String[this.numLans];
                String[] ifName = new String[this.numLans];
                int numEths = 0;
                int i11 = 0;
                while (i11 < this.numLans) {
                    netif = (NetworkInterfaceInformation)this.networkIfs.get(i11);
                    String lanDriver = netif.getDriver();
                    int adapterType = netif.getAdapterType();
                    if (lanDriver.length() > 0 && adapterType == 2) {
                        sw7.write("alias eth" + i11 + " " + lanDriver + "\n");
                        ethDriver[numEths] = lanDriver;
                        ifName[numEths] = netif.getIfname();
                        ++numEths;
                        Trace.trace(TRACE_MASKT, "eth" + i11 + ": driver = " + lanDriver);
                    }
                    ++i11;
                }
                String line = null;
                String e100Options = "";
                String eepro100Options = "";
                String e1000Options = "";
                String bcm5700Options = "";
                while (hostsTokenizer.hasMoreTokens()) {
                    line = hostsTokenizer.nextToken().trim();
                    if (line.startsWith("alias")) {
                        String thisIfname = line.substring(5).trim();
                        if (thisIfname.startsWith("eth")) {
                            thisIfname = thisIfname.substring(0, 5).trim();
                            boolean found = false;
                            int i12 = 0;
                            while (i12 < numEths && !found) {
                                Trace.trace(TRACE_MASKF, "thisIfname = [" + thisIfname + "]; ifName[" + i12 + "] = [" + ifName[i12] + "]");
                                if (thisIfname.equals(ifName[i12])) {
                                    found = true;
                                }
                                ++i12;
                            }
                            if (found) continue;
                            sw7.write(line + "\n");
                            Trace.trace(TRACE_MASKF, "Write: " + line + "\n");
                            continue;
                        }
                    } else if (line.startsWith("options")) {
                        String temp = line.substring(7).trim();
                        if (temp.startsWith("e100 ")) {
                            StringTokenizer options = new StringTokenizer(temp.substring(4).trim(), " ");
                            e100Options = "";
                            while (options.hasMoreTokens()) {
                                String tok = options.nextToken();
                                if (tok.startsWith("e100_speed_duplex=")) continue;
                                e100Options = e100Options + " " + tok;
                            }
                            continue;
                        }
                        if (temp.startsWith("eepro100 ")) {
                            StringTokenizer options = new StringTokenizer(temp.substring(8).trim(), " ");
                            eepro100Options = "";
                            while (options.hasMoreTokens()) {
                                String tok = options.nextToken();
                                if (tok.startsWith("options=")) continue;
                                eepro100Options = eepro100Options + " " + tok;
                            }
                            continue;
                        }
                        if (temp.startsWith("e1000 ")) {
                            StringTokenizer options = new StringTokenizer(temp.substring(5).trim(), " ");
                            e1000Options = "";
                            while (options.hasMoreTokens()) {
                                String tok = options.nextToken();
                                if (tok.startsWith("Speed=") || tok.startsWith("Duplex=")) continue;
                                e1000Options = e1000Options + " " + tok;
                            }
                            continue;
                        }
                        if (temp.startsWith("bcm5700 ")) {
                            StringTokenizer options = new StringTokenizer(temp.substring(7).trim(), " ");
                            bcm5700Options = "";
                            while (options.hasMoreTokens()) {
                                String tok = options.nextToken();
                                if (tok.startsWith("line_speed=") || tok.startsWith("full_duplex=")) continue;
                                bcm5700Options = bcm5700Options + " " + tok;
                            }
                            continue;
                        }
                    } else if (line.startsWith(ETHTOOL_PREFIX)) continue;
                    if (line.length() <= 0) continue;
                    sw7.write(line + "\n");
                }
                String[] mode = new String[numEths];
                String[] duplex = new String[numEths];
                String[] speed = new String[numEths];
                int i13 = 0;
                while (i13 < numEths) {
                    netif = (NetworkInterfaceInformation)this.networkIfs.get(i13);
                    mode[i13] = netif.getMediaSpeed();
                    Trace.trace(TRACE_MASKF, "i = " + i13 + ": mode[" + i13 + "] = " + mode[i13]);
                    mode[i13] = NetworkSettings.getCorrectedMediaSpeed(mode[i13], false);
                    Trace.trace(TRACE_MASKF, "(after correction)  mode[" + i13 + "] = " + mode[i13]);
                    int sindex = mode[i13].indexOf("_median");
                    if (sindex > 0) {
                        String realMSpeed;
                        mode[i13] = realMSpeed = mode[i13].substring(0, sindex);
                    }
                    if (ethDriver[i13].equals("eepro100")) {
                        if (mode[i13].equals("1")) {
                            mode[i13] = "0x40";
                        } else if (mode[i13].equals("2")) {
                            mode[i13] = "0x50";
                        } else if (mode[i13].equals("3")) {
                            mode[i13] = "0x20";
                        } else if (mode[i13].equals("4")) {
                            mode[i13] = "0x30";
                        }
                    }
                    if (ethDriver[i13].equals("e1000")) {
                        if (mode[i13].equals("1")) {
                            speed[i13] = "10";
                            duplex[i13] = "1";
                        } else if (mode[i13].equals("2")) {
                            speed[i13] = "10";
                            duplex[i13] = "2";
                        } else if (mode[i13].equals("3")) {
                            speed[i13] = "100";
                            duplex[i13] = "1";
                        } else if (mode[i13].equals("4")) {
                            speed[i13] = "100";
                            duplex[i13] = "2";
                        } else if (mode[i13].equals("5")) {
                            speed[i13] = "1000";
                            duplex[i13] = "1";
                        } else if (mode[i13].equals("6")) {
                            speed[i13] = "1000";
                            duplex[i13] = "2";
                        } else {
                            speed[i13] = "0";
                            duplex[i13] = "0";
                        }
                    } else if (ethDriver[i13].equals("bcm5700")) {
                        if (mode[i13].equals("1")) {
                            speed[i13] = "10";
                            duplex[i13] = "0";
                        } else if (mode[i13].equals("2")) {
                            speed[i13] = "10";
                            duplex[i13] = "1";
                        } else if (mode[i13].equals("3")) {
                            speed[i13] = "100";
                            duplex[i13] = "0";
                        } else if (mode[i13].equals("4")) {
                            speed[i13] = "100";
                            duplex[i13] = "1";
                        } else if (mode[i13].equals("5")) {
                            speed[i13] = "1000";
                            duplex[i13] = "0";
                        } else if (mode[i13].equals("6")) {
                            speed[i13] = "1000";
                            duplex[i13] = "1";
                        } else {
                            speed[i13] = "0";
                            duplex[i13] = "0";
                        }
                    } else if (ethDriver[i13].equals("tg3")) {
                        if (mode[i13].equals("1")) {
                            speed[i13] = "10";
                            duplex[i13] = "half";
                        } else if (mode[i13].equals("2")) {
                            speed[i13] = "10";
                            duplex[i13] = "full";
                        } else if (mode[i13].equals("3")) {
                            speed[i13] = "100";
                            duplex[i13] = "half";
                        } else if (mode[i13].equals("4")) {
                            speed[i13] = "100";
                            duplex[i13] = "full";
                        } else if (mode[i13].equals("5")) {
                            speed[i13] = "1000";
                            duplex[i13] = "half";
                        } else if (mode[i13].equals("6")) {
                            speed[i13] = "1000";
                            duplex[i13] = "full";
                        } else {
                            speed[i13] = "0";
                            duplex[i13] = "0";
                        }
                    }
                    ++i13;
                }
                int i14 = 0;
                while (i14 < DRIVERS.length) {
                    int numberUsingThisDriver = 0;
                    String thisDriver = "";
                    String optionString = "";
                    ArrayList<String> eths = new ArrayList<String>();
                    j = 0;
                    while (j < numEths) {
                        if (ethDriver[j].equals(DRIVERS[i14])) {
                            ++numberUsingThisDriver;
                            thisDriver = DRIVERS[i14];
                            eths.add(String.valueOf(j));
                            Trace.trace(TRACE_MASKF, "adding: ; thisDriver = " + thisDriver);
                        }
                        ++j;
                    }
                    if (numberUsingThisDriver > 0) {
                        optionString = numberUsingThisDriver > 1 ? NetworkSettings.handleMultiple(thisDriver, eths, e100Options, eepro100Options, e1000Options, bcm5700Options, mode, duplex, speed) : NetworkSettings.handleIndividual(thisDriver, eths, e100Options, eepro100Options, e1000Options, bcm5700Options, mode, duplex, speed);
                        sw7.write(optionString);
                    }
                    ++i14;
                }
                br.close();
                sw7.close();
                this.prepareFileRewrite(ETHERNET_CONFIG_FILE, sw7.toString(), filebuf3, filesToCopy, filesToDelete);
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKD, "I/O Exception " + e);
                lastCaught = e;
            }
            try {
                filebuf3 = this.getFileContents(DNS_FILE, allFileContents);
                sw = new StringWriter(filebuf3.length());
                if (this.networkInfo.isDNSEnabled()) {
                    String[] id;
                    if (REDHAT && this.networkInfo.getDomainName() != null && this.networkInfo.getDomainName().length() > 0) {
                        String s = "domain " + this.networkInfo.getDomainName();
                        sw.write(s);
                        sw.write("\n");
                    }
                    if ((id = this.networkInfo.getDomainSuffixes()) != null && id.length != 0) {
                        String s = "search";
                        int idx = 0;
                        while (idx < id.length) {
                            s = s + " " + id[idx];
                            ++idx;
                        }
                        sw.write(s);
                        sw.write("\n");
                    }
                    if ((id = this.networkInfo.getDNSServers()) != null) {
                        int idx = 0;
                        while (idx < id.length) {
                            String s = "nameserver " + id[idx];
                            sw.write(s);
                            sw.write("\n");
                            ++idx;
                        }
                    }
                }
                sw.close();
                this.prepareFileRewrite(DNS_FILE, sw.toString(), filebuf3, filesToCopy, filesToDelete);
            }
            catch (IOException e) {
                System.out.println("I/O Exception " + e);
                lastCaught = e;
            }
            if (!REDHAT) {
                try {
                    filebuf3 = this.getFileContents(HOSTNAME, allFileContents);
                    sw = new StringWriter(filebuf3.length());
                    String hostName2 = this.networkInfo.getComputerName().trim();
                    String domainName = this.networkInfo.getDomainName().trim();
                    if (domainName.length() > 0) {
                        hostName2 = hostName2 + "." + domainName;
                    }
                    if (hostName2.length() > 0) {
                        sw.write(hostName2);
                        sw.write("\n");
                    }
                    sw.close();
                    this.prepareFileRewrite(HOSTNAME, sw.toString(), filebuf3, filesToCopy, filesToDelete);
                }
                catch (IOException e) {
                    System.out.println("I/O Exception " + e);
                    lastCaught = e;
                }
            }
            try {
                Trace.trace(TRACE_MASKF, "Applying firewall rules...");
                FirewallAdmin fwAdmin = FirewallAdmin.getFirewallAdmin();
                fwAdmin.flushNetAppFirewallChains();
                Iterator it = this.networkIfs.iterator();
                while (it.hasNext()) {
                    NetworkInterfaceInformation netIf = (NetworkInterfaceInformation)it.next();
                    Trace.trace(TRACE_MASKF, "Applying firewall rules for netIf=" + netIf);
                    List firewallRules = netIf.getFirewallRules();
                    if (firewallRules == null) continue;
                    Iterator ruleIt = firewallRules.iterator();
                    while (ruleIt.hasNext()) {
                        NetAppFirewallRule rule = (NetAppFirewallRule)ruleIt.next();
                        fwAdmin.addFirewallRule(rule);
                        if (rule.getAppId().equals("WebSM.name")) {
                            Trace.trace(TRACE_MASKF, "Adding the special rule for WebSM");
                            try {
                                Properties props = new Properties();
                                props.load(new FileInputStream("/usr/websm/codebase/com/ibm/jcb/resources/JCB.properties"));
                                int startPort = Integer.parseInt(props.getProperty("JC_SUPPLIER_PORT"));
                                int endPort = startPort + Integer.parseInt(props.getProperty("JC_SUPPLIER_PORT_RANGE"));
                                rule = new NetAppFirewallRule("-", rule.getInterfaceName(), rule.getSourceAddr(), rule.getSourceAddrMask(), rule.getProtocol(), startPort + ":" + endPort);
                                fwAdmin.addFirewallRule(rule);
                            }
                            catch (Exception e) {
                                Trace.trace(TRACE_MASKF, "Failed to add special rule for WebSM");
                                Trace.trace(TRACE_MASKF, e);
                            }
                            continue;
                        }
                        if (!rule.getAppId().equals("RMC.name")) continue;
                        Trace.trace(TRACE_MASKF, "Adding TCP rule for RMC");
                        rule = new NetAppFirewallRule("-", rule.getInterfaceName(), rule.getSourceAddr(), rule.getSourceAddrMask(), "tcp", rule.getPort());
                        fwAdmin.addFirewallRule(rule);
                    }
                }
                fwAdmin.writeConfigFiles();
            }
            catch (FirewallAdminException e) {
                Trace.trace(TRACE_MASKF, e);
                lastCaught = e;
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, e);
                lastCaught = e;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, e);
                lastCaught = e;
            }
            if (filesToCopy.size() > 0) {
                String[] files = new String[filesToCopy.size() * 2 + 1];
                ListIterator iterator = filesToCopy.listIterator();
                files[0] = CPNETWORKFILES;
                int i15 = 1;
                while (iterator.hasNext()) {
                    String[] filePairs = (String[])iterator.next();
                    files[i15] = filePairs[0];
                    files[i15 + 1] = filePairs[1];
                    Trace.trace(TRACE_MASKF, "files[" + i15 + "]=" + files[i15] + " ;  files[" + (i15 + 1) + "] = " + files[i15 + 1]);
                    i15 += 2;
                }
                String commandResults = this.executeScript(files);
                Trace.trace(TRACE_MASKF, "results of cpNetworkFiles = [" + commandResults + "]");
                iterator = filesToDelete.listIterator();
                while (iterator.hasNext()) {
                    ((File)iterator.next()).delete();
                }
                if (!this.networkInfo.getPlatform().equals("PHMC")) {
                    String computerName = this.networkInfo.getComputerName();
                    String domainName = this.networkInfo.getDomainName();
                    if (domainName.length() > 0) {
                        computerName = computerName + "." + domainName;
                    }
                    String[] setHostParms = new String[]{SETHOSTNAME, computerName};
                    Trace.trace(TRACE_MASKF, "setHostParms: " + setHostParms[1]);
                    commandResults = this.executeScript(setHostParms);
                    Trace.trace(TRACE_MASKF, "results of SETHOSTNAME = [" + commandResults + "]");
                    this.networkRestart();
                } else {
                    Trace.trace(TRACE_MASKF, "PHMC Platform: Reboot instead of ifReset");
                }
                j = 0;
                while (j < this.numLans) {
                    if (this.dhcpClient[j]) {
                        Trace.trace(TRACE_MASKT, "DHCP Client running. Go get new address");
                        ifconfigResults = "";
                        this.networkIfs = this.getIPSettings();
                    }
                    ++j;
                }
                if (!this.networkInfo.getPlatform().equals("PHMC")) {
                    this.startDHCPServer();
                    this.startRouted();
                }
            } else {
                Trace.trace(TRACE_MASKT, "No changes needed in environment files - We're done!");
            }
            if (lastCaught != null) {
                // empty if block
            }
        }
        Trace.trace(TRACE_MASKT, "<- NetworkSettings.updateConfigFiles()");
    }

    private void determineNetworkSettings() {
        String line;
        String filebuf;
        Trace.trace(TRACE_MASKF, "-> NetworkSettings.determineNetworkSettings()");
        String commandSeparator = "***RESULTS OF LS COMMAND***";
        String[] setIfcfgParms = new String[]{RUNIFCFGS, DIRECTORY};
        Trace.trace(TRACE_MASKF, "setIfcfgParms: " + setIfcfgParms[1]);
        String commandResults = this.executeScript(setIfcfgParms);
        Trace.trace(TRACE_MASKF, "commandResults = [" + commandResults + "]");
        int separatorIdx = commandResults.indexOf(commandSeparator);
        String lsResults = "";
        if (separatorIdx != -1) {
            ifconfigResults = commandResults.substring(0, separatorIdx);
            lsResults = commandResults.substring(separatorIdx + commandSeparator.length() + 1);
        }
        Trace.trace(TRACE_MASKF, "\nifconfigResults = " + ifconfigResults);
        Trace.trace(TRACE_MASKF, "\nlsResults = " + lsResults);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.indexOf(".") == -1 && (name.indexOf("ifcfg-eth") != -1 || name.indexOf("ifcfg-tr") != -1);
            }
        };
        File dir = new File(DIRECTORY);
        StringTokenizer lsResultsTokenizer = new StringTokenizer(lsResults);
        ArrayList<String> fileNames = new ArrayList<String>();
        while (lsResultsTokenizer.hasMoreTokens()) {
            String next = lsResultsTokenizer.nextToken();
            if (!filter.accept(dir, next)) continue;
            fileNames.add(next);
            Trace.trace(TRACE_MASKF, "Adding network adapter ifcfg-" + next + " to the list of files");
        }
        fileNames.add(NETWORK_FILE);
        fileNames.add(STATIC_ROUTES_FILE);
        if (REDHAT) {
            fileNames.add(ROUTED_FILE);
        }
        fileNames.add(ETHERNET_CONFIG_FILE);
        fileNames.add(DNS_FILE);
        fileNames.add(HOSTS_FILE);
        if (!REDHAT) {
            fileNames.add(HOSTNAME);
            fileNames.add(DHCPD_CONF_FILE);
        }
        allFileContents = this.readMultipleFileContents(fileNames);
        Trace.trace(TRACE_MASKF, "\nallFileContents = [" + allFileContents + "]end aFC\n");
        networkFileResults = this.getFileContents(NETWORK_FILE, allFileContents);
        staticRoutesFileResults = this.getFileContents(STATIC_ROUTES_FILE, allFileContents);
        if (REDHAT) {
            routedFileResults = this.getFileContents(ROUTED_FILE, allFileContents);
        }
        ethernetConfigFileResults = this.getFileContents(ETHERNET_CONFIG_FILE, allFileContents);
        dnsFileResults = this.getFileContents(DNS_FILE, allFileContents);
        hostsFileResults = this.getFileContents(HOSTS_FILE, allFileContents);
        if (!REDHAT) {
            hostNameResults = this.getFileContents(HOSTNAME, allFileContents);
            dhcpdConfResults = this.getFileContents(DHCPD_CONF_FILE, allFileContents);
        }
        String computerName = "";
        String domainName = "";
        String hostname = "";
        if (REDHAT) {
            hostname = this.getValue("HOSTNAME", networkFileResults);
        } else {
            filebuf = hostNameResults;
            StringTokenizer hostNameTokenizer = new StringTokenizer(filebuf, "\n");
            while (hostNameTokenizer.hasMoreTokens()) {
                String line2 = hostNameTokenizer.nextToken().trim();
                Trace.trace(TRACE_MASKF, "HOSTNAME line = [" + line2 + "]");
                if (line2.length() <= 0) continue;
                hostname = line2.trim();
            }
        }
        if (hostname.length() > 0) {
            int index = hostname.indexOf(".");
            if (index != -1) {
                computerName = hostname.substring(0, hostname.indexOf("."));
                domainName = hostname.substring(hostname.indexOf(".") + 1);
            } else {
                computerName = hostname;
            }
        }
        Trace.trace(TRACE_MASKT, "computerName = [" + computerName + "]");
        Trace.trace(TRACE_MASKT, "domainName = [" + domainName + "]");
        this.networkInfo.setComputerName(computerName);
        this.networkInfo.setDomainName(domainName);
        this.networkIfs = this.getIPSettings();
        filebuf = dnsFileResults;
        StringTokenizer dnsFileTokenizer = new StringTokenizer(filebuf, "\n");
        String domain = "";
        ArrayList<String> dnsServers = new ArrayList<String>();
        ArrayList<String> domainSuffixes = new ArrayList<String>();
        boolean nameServerCtr = false;
        boolean suffixCtr = false;
        while (dnsFileTokenizer.hasMoreTokens()) {
            String line3 = dnsFileTokenizer.nextToken().trim();
            if (line3.startsWith("domain")) {
                domain = line3.substring(6).trim();
                continue;
            }
            if (line3.startsWith("nameserver")) {
                String nameServer = line3.substring(10).trim();
                if (nameServer.length() <= 0) continue;
                dnsServers.add(nameServer);
                Trace.trace(TRACE_MASKF, "DNS nameserver added: " + nameServer);
                continue;
            }
            if (!line3.startsWith("search")) continue;
            domainSuffixes.clear();
            suffixCtr = false;
            StringTokenizer lineTok = new StringTokenizer(line3.substring(6));
            while (lineTok.hasMoreTokens()) {
                String token = lineTok.nextToken();
                domainSuffixes.add(token);
                Trace.trace(TRACE_MASKF, "domainSuffix added: " + token);
            }
        }
        this.networkInfo.setDNSEnabled(dnsFileResults.length() > 0);
        if (domain.length() != 0) {
            this.networkInfo.setDomainName(domain);
        }
        String[] dnsServersList = new String[dnsServers.size()];
        int i = 0;
        Iterator iterator = dnsServers.iterator();
        while (iterator.hasNext()) {
            dnsServersList[i] = (String)iterator.next();
            ++i;
        }
        this.networkInfo.setDNSServers(dnsServersList);
        String[] domainSuffixesList = new String[domainSuffixes.size()];
        i = 0;
        Iterator iterator2 = domainSuffixes.iterator();
        while (iterator2.hasNext()) {
            domainSuffixesList[i] = (String)iterator2.next();
            ++i;
        }
        this.networkInfo.setDomainSuffixes(domainSuffixesList);
        filebuf = staticRoutesFileResults;
        ArrayList<String> types = new ArrayList<String>();
        ArrayList<String> destinations = new ArrayList<String>();
        ArrayList<String> gateways = new ArrayList<String>();
        ArrayList<String> subnetmasks = new ArrayList<String>();
        ArrayList<String> interfaces = new ArrayList<String>();
        StringTokenizer staticRoutesTokenizer = new StringTokenizer(filebuf, "\n");
        int numEntries = 0;
        while (staticRoutesTokenizer.hasMoreTokens()) {
            boolean done;
            String token;
            String line4 = staticRoutesTokenizer.nextToken().trim();
            Trace.trace(TRACE_MASKF, "routes line = [" + line4 + "]");
            boolean destAdded = false;
            boolean typeAdded = false;
            boolean gatewayAdded = false;
            boolean subnetmaskAdded = false;
            boolean interfaceAdded = false;
            boolean error = false;
            StringTokenizer lineTok = new StringTokenizer(line4);
            if (!lineTok.hasMoreTokens()) continue;
            if (REDHAT) {
                if (line4.startsWith("any ") || line4.startsWith("eth") || line4.startsWith("tr")) {
                    line4 = line4.substring(line4.indexOf(" ") + 1).trim();
                    Trace.trace(TRACE_MASKF, "trimmed line = [" + line4 + "]");
                }
                if (!(line4.startsWith("net ") || line4.startsWith("host ") || line4.startsWith("default "))) {
                    Trace.trace(TRACE_MASKF, "cannot interpret line");
                    continue;
                }
                token = lineTok.nextToken();
                types.add(token);
                Trace.trace(TRACE_MASKF, "types = " + token);
                typeAdded = true;
                done = false;
                if (lineTok.hasMoreTokens()) {
                    token = lineTok.nextToken();
                    if (token.equals("netmask") || token.equals("gw")) {
                        Trace.trace(TRACE_MASKF, "No destination was entered");
                        destinations.add(" ");
                        destAdded = true;
                    } else {
                        destinations.add(token);
                        Trace.trace(TRACE_MASKF, "destination = " + token);
                        destAdded = true;
                        if (lineTok.hasMoreTokens()) {
                            token = lineTok.nextToken();
                        } else {
                            done = true;
                        }
                    }
                    while (!done) {
                        if (token.equals("netmask") && !subnetmaskAdded) {
                            if (lineTok.hasMoreTokens()) {
                                token = lineTok.nextToken();
                                subnetmasks.add(token);
                                Trace.trace(TRACE_MASKF, "subnetmask = " + token);
                                subnetmaskAdded = true;
                            } else {
                                error = true;
                            }
                        } else if (token.equals("gw") && !gatewayAdded) {
                            if (lineTok.hasMoreTokens()) {
                                token = lineTok.nextToken();
                                gateways.add(token);
                                Trace.trace(TRACE_MASKF, "gateway = " + token);
                                gatewayAdded = true;
                            } else {
                                error = true;
                            }
                        } else {
                            error = true;
                        }
                        if (lineTok.hasMoreTokens()) {
                            token = lineTok.nextToken();
                            continue;
                        }
                        done = true;
                    }
                } else {
                    error = true;
                }
                if (error) {
                    Trace.trace(TRACE_MASKF, "error encountered; remove values");
                    if (typeAdded) {
                        types.remove(numEntries);
                    }
                    if (destAdded) {
                        destinations.remove(numEntries);
                    }
                    if (gatewayAdded) {
                        gateways.remove(numEntries);
                    }
                    if (!subnetmaskAdded) continue;
                    subnetmasks.remove(numEntries);
                    continue;
                }
                if (!gatewayAdded) {
                    gateways.add(" ");
                }
                if (!subnetmaskAdded) {
                    subnetmasks.add(" ");
                }
                ++numEntries;
                continue;
            }
            token = lineTok.nextToken();
            if (token.startsWith("#")) {
                Trace.trace(TRACE_MASKF, "Ignore comments");
                continue;
            }
            if (token.equals("default")) {
                Trace.trace(TRACE_MASKF, "Found Default Gateway = " + token + " (process later)");
                continue;
            }
            done = false;
            error = true;
            String destination = "";
            String gateway = "";
            String subnetmask = "";
            while (!done) {
                if (!destAdded) {
                    if (token.equals("-")) {
                        destinations.add(" ");
                        destination = " ";
                        Trace.trace(TRACE_MASKF, "No destination value was entered");
                        destAdded = true;
                    } else {
                        destinations.add(token);
                        destination = token;
                        Trace.trace(TRACE_MASKF, "destination = " + token);
                        destAdded = true;
                    }
                } else if (!gatewayAdded) {
                    if (token.equals("-")) {
                        gateways.add(" ");
                        gateway = " ";
                        Trace.trace(TRACE_MASKF, "No gateway value was entered");
                        gatewayAdded = true;
                    } else {
                        gateways.add(token);
                        gateway = token;
                        Trace.trace(TRACE_MASKF, "gateway = " + token);
                        gatewayAdded = true;
                    }
                } else if (!subnetmaskAdded) {
                    if (token.equals("-")) {
                        subnetmasks.add(" ");
                        subnetmask = " ";
                        Trace.trace(TRACE_MASKF, "No subnetmask value was entered");
                        subnetmaskAdded = true;
                    } else {
                        subnetmasks.add(token);
                        subnetmask = token;
                        Trace.trace(TRACE_MASKF, "subnetmask = " + token);
                        subnetmaskAdded = true;
                    }
                } else if (!interfaceAdded) {
                    if (token.equals("-")) {
                        interfaces.add(" ");
                        Trace.trace(TRACE_MASKF, "No interface value was entered");
                        interfaceAdded = true;
                        error = false;
                        done = true;
                    } else {
                        interfaces.add(token);
                        Trace.trace(TRACE_MASKF, "interface = " + token);
                        interfaceAdded = true;
                        error = false;
                        done = true;
                    }
                    if (!error) {
                        if ((destination.equals(" ") || destination.equals("0.0.0.0")) && (subnetmask.equals(" ") || subnetmask.equals("0.0.0.0"))) {
                            types.add("Default");
                        } else if (subnetmask.equals(" ") || subnetmask.equals("255.255.255.255")) {
                            types.add("Host");
                        } else {
                            types.add("Net");
                        }
                    }
                }
                if (lineTok.hasMoreTokens()) {
                    token = lineTok.nextToken();
                    continue;
                }
                done = true;
            }
            if (error) {
                Trace.trace(TRACE_MASKF, "error encountered; remove values");
                if (typeAdded) {
                    types.remove(numEntries);
                }
                if (destAdded) {
                    destinations.remove(numEntries);
                }
                if (gatewayAdded) {
                    gateways.remove(numEntries);
                }
                if (!subnetmaskAdded) continue;
                subnetmasks.remove(numEntries);
                continue;
            }
            ++numEntries;
        }
        Trace.trace(TRACE_MASKF, "  number of RouteTable entries = " + numEntries);
        Trace.trace(TRACE_MASKF, "  types.size() = " + types.size());
        Trace.trace(TRACE_MASKF, "  destinations.size() = " + destinations.size());
        this.networkInfo.setTypeVector(new Vector(types));
        this.networkInfo.setDestinationVector(new Vector(destinations));
        this.networkInfo.setGatewayVector(new Vector(gateways));
        this.networkInfo.setSubnetMaskVector(new Vector(subnetmasks));
        this.networkInfo.setInterfaceVector(new Vector(interfaces));
        String gateway = "";
        int numLans = this.networkIfs.size();
        if (REDHAT) {
            gateway = this.getValue("GATEWAY=", networkFileResults);
            if (gateway.equals("")) {
                gateway = this.getValue("GATEWAY ", networkFileResults);
            }
        } else {
            filebuf = networkFileResults;
            StringTokenizer networkFileTokenizer = new StringTokenizer(filebuf, "\n");
            while (networkFileTokenizer.hasMoreTokens()) {
                String line5 = networkFileTokenizer.nextToken().trim();
                Trace.trace(TRACE_MASKF, "networkFile line = [" + line5 + "]");
                if (!line5.startsWith("default")) continue;
                StringTokenizer lineTokenizer = new StringTokenizer(line5);
                String[] defaultLine = new String[4];
                i = 0;
                while (i <= 4 && lineTokenizer.hasMoreTokens()) {
                    defaultLine[i] = "-";
                    if (lineTokenizer.hasMoreTokens()) {
                        defaultLine[i] = lineTokenizer.nextToken().trim();
                    }
                    ++i;
                }
                gateway = defaultLine[1];
                String gatewayDev = "-";
                if (defaultLine[3] == null) {
                    Trace.trace(TRACE_MASKF, "gatewayDev is bad.  Assume - ");
                } else {
                    gatewayDev = defaultLine[3];
                }
                this.networkInfo.setGatewayDev(gatewayDev);
            }
        }
        Trace.trace(TRACE_MASKT, "default gateway = [" + gateway + "]");
        this.networkInfo.setDefaultGateway(gateway);
        if (REDHAT) {
            String gatewayDev = this.getValue("GATEWAYDEV", networkFileResults);
            Trace.trace(TRACE_MASKT, "gateway device = " + gatewayDev);
            this.networkInfo.setGatewayDev(gatewayDev);
        }
        numLans = this.networkIfs.size();
        this.ipAddr = new String[numLans];
        Trace.trace(TRACE_MASKT, "numLans = " + numLans);
        if (numLans > 0) {
            i = 0;
            while (i < numLans) {
                NetworkInterfaceInformation netif = (NetworkInterfaceInformation)this.networkIfs.get(i);
                this.ipAddr[i] = netif.getIpAddr();
                Trace.trace(TRACE_MASKT, "netif[" + i + "]: [" + this.ipAddr[i] + "]; ");
                ++i;
            }
        }
        filebuf = hostsFileResults;
        StringTokenizer hostsTokenizer = new StringTokenizer(filebuf, "\n");
        ArrayList<String> ipaddrs = new ArrayList<String>();
        ArrayList<String> hostNames = new ArrayList<String>();
        boolean ctr = false;
        while (hostsTokenizer.hasMoreTokens()) {
            String ipAddress;
            StringTokenizer lineTokenizer;
            String line6 = hostsTokenizer.nextToken().trim();
            Trace.trace(TRACE_MASKF, "line = [" + line6 + "]");
            if (line6.startsWith("#") || line6.length() == 0 || !(lineTokenizer = new StringTokenizer(line6)).hasMoreTokens() || (ipAddress = lineTokenizer.nextToken()).equals("127.0.0.1")) continue;
            i = 0;
            while (i < numLans) {
                if (ipAddress.equals(this.ipAddr[i])) {
                    // empty if block
                }
                ++i;
            }
            StringBuffer hostsBuffer = new StringBuffer();
            while (lineTokenizer.hasMoreTokens()) {
                hostsBuffer.append(lineTokenizer.nextToken().trim());
                hostsBuffer.append(' ');
            }
            String hosts = hostsBuffer.toString().trim();
            ipaddrs.add(ipAddress);
            hostNames.add(hosts);
            Trace.trace(TRACE_MASKF, "ipAddress = " + ipAddress + ";  hosts = " + hosts);
        }
        Vector hostsAddresses = new Vector(ipaddrs);
        Vector hostsNames = new Vector(hostNames);
        this.networkInfo.setHostsAddresses(hostsAddresses);
        this.networkInfo.setHostsNames(hostsNames);
        if (this.networkInfo.getPlatform().equals("ZHMC") || this.networkInfo.getPlatform().equals("PHMC")) {
            filebuf = dhcpdConfResults;
            Trace.trace(TRACE_MASKF, "*** Process the dhcpd.conf file ***");
            int foundIndex = 0;
            boolean done = false;
            while (!done) {
                foundIndex = filebuf.indexOf("# option routers");
                if (foundIndex != -1) {
                    filebuf = filebuf.substring(0, foundIndex) + " " + filebuf.substring(foundIndex + 1);
                    continue;
                }
                done = true;
            }
            StringTokenizer dhcpFileTokenizer = new StringTokenizer(filebuf, "\n");
            int numDHCPServers = 0;
            while (dhcpFileTokenizer.hasMoreTokens()) {
                line = dhcpFileTokenizer.nextToken().trim();
                if (!line.startsWith("range")) continue;
                ++numDHCPServers;
            }
            Trace.trace(TRACE_MASKF, "Number of DHCPServers = " + numDHCPServers);
            String[] rangeStart = new String[numDHCPServers];
            String[] rangeEnd = new String[numDHCPServers];
            String[] serverAddr = new String[numDHCPServers];
            String[] subnetAddr = new String[numDHCPServers];
            String[] maskAddr = new String[numDHCPServers];
            boolean rangeFound = false;
            dhcpFileTokenizer = new StringTokenizer(filebuf, "\n");
            boolean processingSubnet = false;
            int j = -1;
            while (dhcpFileTokenizer.hasMoreTokens()) {
                String line7 = dhcpFileTokenizer.nextToken().trim();
                if (line7.startsWith("option routers")) {
                    if (!processingSubnet) {
                        ++j;
                        processingSubnet = true;
                    }
                    rangeFound = false;
                    serverAddr[j] = line7.substring(14).trim();
                    int semiColonLoc = serverAddr[j].indexOf(";");
                    if (semiColonLoc != -1) {
                        serverAddr[j] = serverAddr[j].substring(0, semiColonLoc).trim();
                        Trace.trace(TRACE_MASKF, "serverAddr[" + j + "] = [" + serverAddr[j] + "] serverAddr.length = " + serverAddr[j].length());
                    }
                    Trace.trace(TRACE_MASKF, "'option routers' found: [" + serverAddr[j] + "]");
                    continue;
                }
                if (line7.startsWith("option subnet-mask")) {
                    Trace.trace(TRACE_MASKF, "'option subnet-mask' found - continue");
                    continue;
                }
                if (line7.startsWith("option domain-name-servers")) {
                    Trace.trace(TRACE_MASKF, "'option domain-name-servers' found - continue");
                    continue;
                }
                if (line7.startsWith("subnet")) {
                    int blankLoc;
                    Trace.trace(TRACE_MASKF, "'subnet' found in line: [" + line7 + "]");
                    if (!processingSubnet) {
                        ++j;
                        processingSubnet = true;
                    }
                    if ((blankLoc = (line7 = line7.substring(7).trim()).indexOf(" ")) == -1) continue;
                    subnetAddr[j] = line7.substring(0, blankLoc);
                    line7 = line7.substring(blankLoc).trim();
                    Trace.trace(TRACE_MASKF, "subnetAddr[" + j + "] = [" + subnetAddr[j] + "] subnetAddr.length = " + subnetAddr[j].length());
                    int netmaskLoc = line7.indexOf("netmask");
                    if (netmaskLoc == -1) continue;
                    maskAddr[j] = line7.substring(netmaskLoc + 7).trim();
                    int bracketLoc = maskAddr[j].indexOf(START_BRACKET);
                    if (bracketLoc == -1) continue;
                    maskAddr[j] = maskAddr[j].substring(0, bracketLoc).trim();
                    Trace.trace(TRACE_MASKF, "maskAddr[" + j + "] = [" + maskAddr[j] + "] maskAddr.length = " + maskAddr[j].length());
                    continue;
                }
                if (!rangeFound) {
                    int rangeLoc = line7.indexOf("range");
                    if (line7.indexOf("range") == -1) continue;
                    Trace.trace(TRACE_MASKF, "'range' found: [" + line7 + "]");
                    rangeFound = true;
                    line7 = line7.substring(rangeLoc + 6).trim();
                    int blankLoc = line7.indexOf(" ");
                    if (blankLoc == -1) continue;
                    rangeStart[j] = line7.substring(0, blankLoc);
                    rangeEnd[j] = line7.substring(blankLoc + 1).trim();
                    int semiColonLoc = rangeEnd[j].indexOf(";");
                    if (semiColonLoc == -1) continue;
                    rangeEnd[j] = rangeEnd[j].substring(0, semiColonLoc);
                    Trace.trace(TRACE_MASKF, "rangeEnd[" + j + "] = [" + rangeEnd[j] + "] rangeEnd.length = " + rangeEnd[j].length());
                    continue;
                }
                if (!line7.startsWith(END_BRACKET)) continue;
                processingSubnet = false;
            }
            Trace.trace(TRACE_MASKF, "Summarize:");
            boolean foundOne = false;
            j = 0;
            while (j < numDHCPServers) {
                boolean found = false;
                i = 0;
                while (i < numLans && !found) {
                    Trace.trace(TRACE_MASKF, " serverAddr[" + j + "] = [" + serverAddr[j] + "]; ipAddr[" + i + "] = [" + this.ipAddr[i] + "]");
                    if (serverAddr[j].equals(this.ipAddr[i])) {
                        Trace.trace(TRACE_MASKF, "Server address[" + j + "] matches lan[" + i + "]: " + this.ipAddr[i]);
                        found = true;
                        Trace.trace(TRACE_MASKF, "Range[" + j + "] = " + rangeStart[j] + " - " + rangeEnd[j]);
                        Trace.trace(TRACE_MASKF, "Subnet[" + j + "] = " + subnetAddr[j] + "; Mask[" + j + "] = " + maskAddr[j]);
                        if (serverAddr[j] != null && serverAddr[j].length() > 0 && maskAddr[j] != null && maskAddr[j].length() > 0 && rangeStart[j] != null && rangeStart[j].length() > 0 && rangeEnd[j] != null && rangeEnd[j].length() > 0) {
                            Trace.trace(TRACE_MASKF, "OK to store these values i = " + i + ": j = " + j);
                            NetworkInterfaceInformation netif = (NetworkInterfaceInformation)this.networkIfs.get(i);
                            netif.setDhcpServer(true);
                            Trace.trace(TRACE_MASKF, "Set " + netif.getIfname() + " (" + i + ") dhcpServer = true");
                            DHCPServerRangeConfig dhcpServerConfig = netif.getDhcpServerRangeConfig();
                            dhcpServerConfig.setHmcAddress(serverAddr[j]);
                            dhcpServerConfig.setStart(rangeStart[j]);
                            dhcpServerConfig.setEnd(rangeEnd[j]);
                            dhcpServerConfig.setSubnet(subnetAddr[j]);
                            dhcpServerConfig.setMask(maskAddr[j]);
                            netif.setDhcpServerRangeConfig(dhcpServerConfig);
                            netif.setConfigured(true);
                            this.networkIfs.set(i, netif);
                            Trace.trace(TRACE_MASKF, netif.getIfname() + " values stored: i = " + i + ": j = " + j);
                            foundOne = true;
                        } else {
                            Trace.trace(TRACE_MASKF, "Problems - ignore this lan as a DHCP Server");
                        }
                    }
                    ++i;
                }
                ++j;
            }
            i = 0;
            while (i < this.networkIfs.size()) {
                NetworkInterfaceInformation netifSumm = (NetworkInterfaceInformation)this.networkIfs.get(i);
                Trace.trace(TRACE_MASKT, "Ending dhcpserver summarize ");
                Trace.trace(TRACE_MASKT, "netif" + i + ".getIpAddress(): " + netifSumm.getIpAddr());
                Trace.trace(TRACE_MASKT, "netif" + i + ".isDhcpServer(): " + netifSumm.isDhcpServer());
                Trace.trace(TRACE_MASKT, "netif" + i + ".isConfigured(): " + netifSumm.isConfigured());
                if (netifSumm.isDhcpServer()) {
                    DHCPServerRangeConfig dhcpServerConfigSumm = netifSumm.getDhcpServerRangeConfig();
                    Trace.trace(TRACE_MASKT, " dhcpServerConfigSumm for " + netifSumm.getIfname() + ": " + dhcpServerConfigSumm.getStart() + " , " + dhcpServerConfigSumm.getEnd() + " , " + dhcpServerConfigSumm.getSubnet() + " , " + dhcpServerConfigSumm.getMask());
                }
                ++i;
            }
            if (!foundOne) {
                Trace.trace(TRACE_MASKF, "DHCPServer range NOT SET - no Lan IP matched");
            }
        } else {
            Trace.trace(TRACE_MASKF, "Ignore dhcpd.conf file on SE or ALTSE");
        }
        filebuf = ethernetConfigFileResults;
        StringTokenizer ethernetConfigTokenizer = new StringTokenizer(filebuf, "\n");
        String[] ethDriver = new String[numLans];
        int numEths = 0;
        boolean done = false;
        while (ethernetConfigTokenizer.hasMoreTokens() && !done && ethDriver.length > 0) {
            line = ethernetConfigTokenizer.nextToken().trim();
            if (!line.startsWith("alias") || !(line = line.substring(5).trim()).startsWith("eth")) continue;
            String adapter = line.substring(0, 4).trim();
            String driver = line.substring(4).trim();
            if (!driver.equals("off")) {
                ethDriver[numEths] = line.substring(4).trim();
                if (++numEths != numLans) continue;
                done = true;
                Trace.trace(TRACE_MASKF, "Found as many ethernet cards as we have number of lan cards.  Stop looking; numEths = " + numEths);
                continue;
            }
            Trace.trace(TRACE_MASKF, "alias " + adapter + " set to off - ignore");
        }
        ethernetConfigTokenizer = new StringTokenizer(filebuf, "\n");
        String[] mode = new String[numEths];
        String[] duplexMode = new String[numEths];
        String[] speedMode = new String[numEths];
        i = 0;
        while (i < numEths) {
            mode[i] = "0";
            duplexMode[i] = "0";
            speedMode[i] = "0";
            ++i;
        }
        while (ethernetConfigTokenizer.hasMoreTokens()) {
            String line8 = ethernetConfigTokenizer.nextToken().trim();
            if (line8.startsWith("options")) {
                int idx;
                if ((line8 = line8.substring(7).trim()).startsWith("bcm5700")) {
                    int idx2 = (line8 = line8.substring(7).trim()).indexOf("full_duplex=");
                    if (idx2 > -1) {
                        String duplexOption = line8.substring(idx2 += 12).trim();
                        if (duplexOption.indexOf(" ") > -1) {
                            duplexOption = duplexOption.substring(0, duplexOption.indexOf(" ")).trim();
                        }
                        if (duplexOption.indexOf(",") > -1) {
                            i = 0;
                            while (i < numEths) {
                                if (ethDriver[i].equals("bcm5700")) {
                                    duplexMode[i] = duplexOption.substring(0, duplexOption.indexOf(","));
                                }
                                ++i;
                            }
                        } else {
                            i = 0;
                            while (i < numEths) {
                                if (ethDriver[i].equals("bcm5700")) {
                                    duplexMode[i] = duplexOption;
                                }
                                ++i;
                            }
                        }
                    }
                    if ((idx2 = line8.indexOf("line_speed=")) <= -1) continue;
                    String speedOption = line8.substring(idx2 += 11).trim();
                    if (speedOption.indexOf(" ") > -1) {
                        speedOption = speedOption.substring(0, speedOption.indexOf(" ")).trim();
                    }
                    if (speedOption.indexOf(",") > -1) {
                        i = 0;
                        while (i < numEths) {
                            if (ethDriver[i].equals("bcm5700")) {
                                speedMode[i] = speedOption.substring(0, speedOption.indexOf(","));
                            }
                            ++i;
                        }
                        continue;
                    }
                    i = 0;
                    while (i < numEths) {
                        if (ethDriver[i].equals("bcm5700")) {
                            speedMode[i] = speedOption;
                        }
                        ++i;
                    }
                    continue;
                }
                if (line8.startsWith("e1000")) {
                    int idx3 = (line8 = line8.substring(5).trim()).indexOf("Duplex=");
                    if (idx3 > -1) {
                        String duplexOption = line8.substring(idx3 += 7).trim();
                        if (duplexOption.indexOf(" ") > -1) {
                            duplexOption = duplexOption.substring(0, duplexOption.indexOf(" ")).trim();
                        }
                        if (duplexOption.indexOf(",") > -1) {
                            i = 0;
                            while (i < numEths) {
                                if (ethDriver[i].equals("e1000")) {
                                    duplexMode[i] = duplexOption.substring(0, duplexOption.indexOf(","));
                                }
                                ++i;
                            }
                        } else {
                            i = 0;
                            while (i < numEths) {
                                if (ethDriver[i].equals("e1000")) {
                                    duplexMode[i] = duplexOption;
                                }
                                ++i;
                            }
                        }
                    }
                    if ((idx3 = line8.indexOf("Speed=")) <= -1) continue;
                    String speedOption = line8.substring(idx3 += 6).trim();
                    if (speedOption.indexOf(" ") > -1) {
                        speedOption = speedOption.substring(0, speedOption.indexOf(" ")).trim();
                    }
                    if (speedOption.indexOf(",") > -1) {
                        i = 0;
                        while (i < numEths) {
                            if (ethDriver[i].equals("e1000")) {
                                speedMode[i] = speedOption.substring(0, speedOption.indexOf(","));
                            }
                            ++i;
                        }
                        continue;
                    }
                    i = 0;
                    while (i < numEths) {
                        if (ethDriver[i].equals("e1000")) {
                            speedMode[i] = speedOption;
                        }
                        ++i;
                    }
                    continue;
                }
                if (line8.startsWith("e100")) {
                    int idx4 = (line8 = line8.substring(4).trim()).indexOf("e100_speed_duplex=");
                    if (idx4 <= -1) continue;
                    if ((line8 = line8.substring(idx4 += 18).trim()).indexOf(" ") > -1) {
                        line8 = line8.substring(0, line8.indexOf(" ")).trim();
                    }
                    if (line8.indexOf(",") > -1) {
                        i = 0;
                        while (i < numEths) {
                            if (ethDriver[i].equals("e100")) {
                                mode[i] = line8.substring(0, line8.indexOf(","));
                            }
                            ++i;
                        }
                        continue;
                    }
                    i = 0;
                    while (i < numEths) {
                        if (ethDriver[i].equals("e100")) {
                            mode[i] = line8;
                        }
                        ++i;
                    }
                    continue;
                }
                if (!line8.startsWith("eepro100") || (idx = (line8 = line8.substring(8).trim()).indexOf("options=")) <= -1) continue;
                if ((line8 = line8.substring(idx += 8).trim()).indexOf(" ") > -1) {
                    line8 = line8.substring(0, line8.indexOf(" ")).trim();
                }
                if (line8.indexOf(",") > -1) {
                    i = 0;
                    while (i < numEths) {
                        if (ethDriver[i].equals("eepro100")) {
                            mode[i] = line8.substring(0, line8.indexOf(","));
                        }
                        ++i;
                    }
                    continue;
                }
                i = 0;
                while (i < numEths) {
                    if (ethDriver[i].equals("eepro100")) {
                        mode[i] = line8;
                    }
                    ++i;
                }
                continue;
            }
            if (!line8.startsWith(ETHTOOL_PREFIX) || !(line8 = line8.substring(ETHTOOL_PREFIX.length()).trim()).startsWith("eth")) continue;
            String adapter = line8.substring(0, 4);
            int idx = (line8 = line8.substring(4).trim()).indexOf("autoneg ");
            if (idx <= -1) continue;
            String subLine = line8.substring(idx + 8).trim();
            if ((idx = subLine.indexOf(" ")) > -1) {
                subLine = subLine.substring(0, idx).trim();
            }
            if (!subLine.equals("off")) continue;
            idx = line8.indexOf("speed ");
            if (idx > -1) {
                subLine = line8.substring(idx + 6).trim();
                if ((idx = subLine.indexOf(" ")) > -1) {
                    subLine = subLine.substring(0, idx).trim();
                }
                i = 0;
                while (i < numEths) {
                    if (adapter.equals("eth" + i)) {
                        speedMode[i] = subLine;
                    }
                    ++i;
                }
            }
            if ((idx = line8.indexOf("duplex ")) <= -1) continue;
            subLine = line8.substring(idx + 7).trim();
            if ((idx = subLine.indexOf(" ")) > -1) {
                subLine = subLine.substring(0, idx).trim();
            }
            i = 0;
            while (i < numEths) {
                if (adapter.equals("eth" + i)) {
                    duplexMode[i] = subLine;
                }
                ++i;
            }
        }
        i = 0;
        while (i < numEths) {
            if (ethDriver[i].equals("eepro100")) {
                if (mode[i].equalsIgnoreCase("0x40")) {
                    mode[i] = "1";
                } else if (mode[i].equalsIgnoreCase("0x50")) {
                    mode[i] = "2";
                } else if (mode[i].equalsIgnoreCase("0x20")) {
                    mode[i] = "3";
                } else if (mode[i].equalsIgnoreCase("0x30")) {
                    mode[i] = "4";
                }
            }
            ++i;
        }
        i = 0;
        while (i < numEths) {
            if (ethDriver[i].equals("e1000")) {
                mode[i] = duplexMode[i].equals("1") && speedMode[i].equals("10") ? "1" : (duplexMode[i].equals("1") && speedMode[i].equals("100") ? "3" : (duplexMode[i].equals("1") && speedMode[i].equals("1000") ? "5" : (duplexMode[i].equals("2") && speedMode[i].equals("10") ? "2" : (duplexMode[i].equals("2") && speedMode[i].equals("100") ? "4" : (duplexMode[i].equals("2") && speedMode[i].equals("1000") ? "6" : "0")))));
            }
            ++i;
        }
        i = 0;
        while (i < numEths) {
            if (ethDriver[i].equals("bcm5700")) {
                mode[i] = duplexMode[i].equals("0") && speedMode[i].equals("10") ? "1" : (duplexMode[i].equals("0") && speedMode[i].equals("100") ? "3" : (duplexMode[i].equals("0") && speedMode[i].equals("1000") ? "5" : (duplexMode[i].equals("1") && speedMode[i].equals("10") ? "2" : (duplexMode[i].equals("1") && speedMode[i].equals("100") ? "4" : (duplexMode[i].equals("1") && speedMode[i].equals("1000") ? "6" : "0")))));
            }
            ++i;
        }
        i = 0;
        while (i < numEths) {
            if (ethDriver[i].equals("tg3")) {
                mode[i] = duplexMode[i].equals("half") && speedMode[i].equals("10") ? "1" : (duplexMode[i].equals("half") && speedMode[i].equals("100") ? "3" : (duplexMode[i].equals("half") && speedMode[i].equals("1000") ? "5" : (duplexMode[i].equals("full") && speedMode[i].equals("10") ? "2" : (duplexMode[i].equals("full") && speedMode[i].equals("100") ? "4" : (duplexMode[i].equals("full") && speedMode[i].equals("1000") ? "6" : "0")))));
            }
            ++i;
        }
        i = 0;
        while (i < numEths) {
            if (ethDriver[i].equals("eepro100")) {
                int j = 0;
                while (j < numEths) {
                    if (ethDriver[j].equals("e100")) {
                        ethDriver[j] = "eepro100";
                        mode[j] = mode[i];
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < numEths) {
            NetworkInterfaceInformation netif = (NetworkInterfaceInformation)this.networkIfs.get(i);
            String cmode = NetworkSettings.getCorrectedMediaSpeed(mode[i], true);
            netif.setMediaSpeed(cmode);
            netif.setDriver(ethDriver[i]);
            Trace.trace(TRACE_MASKT, "eth" + i + ": cmode = " + cmode + ": driver = " + ethDriver[i]);
            ++i;
        }
        Trace.trace(TRACE_MASKF, "<- NetworkSettings.determineNetworkSettings()");
    }

    private List getIPSettings() {
        Trace.trace(TRACE_MASKF, "-> NetworkSettings.getIPSettings()");
        ArrayList<NetworkInterfaceInformation> info = new ArrayList<NetworkInterfaceInformation>();
        ArrayList ipaddresses = new ArrayList();
        try {
            String line;
            if (ifconfigResults.trim().equals("")) {
                Trace.trace(TRACE_MASKT, "ifconfig never run - run it now");
                allFileContents = this.getInstalledCards();
                networkFileResults = this.getFileContents(NETWORK_FILE, allFileContents);
            } else {
                Trace.trace(TRACE_MASKT, "ifconfig already run - use previous results");
            }
            StringReader sr = new StringReader(ifconfigResults);
            BufferedReader in = new BufferedReader(sr);
            boolean inIf = false;
            String ipaddr = "";
            String netmask = "";
            String mac = "";
            String ifname = "";
            boolean dhcpClient = false;
            boolean privateIf = true;
            if (!this.networkInfo.getPlatform().equals("PHMC")) {
                privateIf = false;
            }
            String driver = "";
            String mediaSpeed = "";
            boolean dhcpServer = false;
            do {
                DHCPServerRangeConfig dhcpServerConfig;
                if ((line = in.readLine()) != null) {
                    int pos = line.indexOf("Link encap");
                    if (pos != -1) {
                        StringTokenizer tokens = new StringTokenizer(line);
                        if (inIf) {
                            dhcpClient = this.getDhcpClientSetting(ifname, allFileContents);
                            dhcpServerConfig = new DHCPServerRangeConfig();
                            NetworkInterfaceInformation netif = new NetworkInterfaceInformation(ipaddr, netmask, ifname, mac, dhcpClient, privateIf, driver, mediaSpeed, dhcpServer, dhcpServerConfig, false, false);
                            Trace.trace(TRACE_MASKF, "Adding interface to the list: " + ipaddr + " , " + netmask + "\n" + ifname + " , " + mac + " , " + dhcpClient + " , " + privateIf + "," + driver + "," + mediaSpeed + "," + dhcpServer);
                            info.add(netif);
                        }
                        ifname = tokens.nextToken();
                        Trace.trace(TRACE_MASKD, "ifname = [" + ifname + "]");
                        if (!ifname.startsWith("eth") && !ifname.startsWith("tr")) {
                            ifname = "";
                            inIf = false;
                        } else {
                            ipaddr = "";
                            netmask = "";
                            mac = "";
                            inIf = true;
                        }
                    }
                    if (!inIf) continue;
                    pos = line.indexOf("inet addr:");
                    if (pos != -1) {
                        int len = 10;
                        int lastpos = line.indexOf(" ", pos + len);
                        ipaddr = lastpos != -1 ? line.substring(pos + len, lastpos) : line.substring(pos + len);
                        Trace.trace(TRACE_MASKD, "Found IP Address = " + ipaddr);
                    }
                    if ((pos = line.indexOf("Mask:")) != -1) {
                        int len = 5;
                        int lastpos = line.indexOf(" ", pos + len);
                        netmask = lastpos != -1 ? line.substring(pos + len, lastpos) : line.substring(pos + len);
                        Trace.trace(TRACE_MASKD, "Found netmask = " + netmask);
                    }
                    if ((pos = line.indexOf("HWaddr ")) == -1) continue;
                    int len = 7;
                    int lastpos = line.indexOf(" ", pos + len);
                    String mac1 = lastpos != -1 ? line.substring(pos + len, lastpos) : line.substring(pos + len);
                    StringTokenizer mactokens = new StringTokenizer(mac1, ":");
                    mac = "";
                    while (mactokens.hasMoreElements()) {
                        mac = mac + mactokens.nextToken();
                    }
                    Trace.trace(TRACE_MASKD, "Found mac address = " + mac);
                    continue;
                }
                if (!inIf) continue;
                dhcpClient = this.getDhcpClientSetting(ifname, allFileContents);
                dhcpServerConfig = new DHCPServerRangeConfig();
                NetworkInterfaceInformation netif = new NetworkInterfaceInformation(ipaddr, netmask, ifname, mac, dhcpClient, privateIf, driver, mediaSpeed, dhcpServer, dhcpServerConfig, false, false);
                Trace.trace(TRACE_MASKF, "ADDING interface to the list: " + ipaddr + " , " + netmask + "\n" + ifname + " , " + mac + " , " + dhcpClient + " , " + privateIf + "," + driver + "," + mediaSpeed + "," + dhcpServer);
                info.add(netif);
            } while (line != null);
        }
        catch (IOException e) {
            System.out.println("caught IOException: " + e);
            e.printStackTrace();
        }
        try {
            Trace.trace(TRACE_MASKF, "Reading firewall settings...");
            FirewallAdmin fwAdmin = FirewallAdmin.getFirewallAdmin();
            Iterator it = info.iterator();
            while (it.hasNext()) {
                NetworkInterfaceInformation netif = (NetworkInterfaceInformation)it.next();
                Trace.trace(TRACE_MASKF, "Reading firewall settings for netif=" + netif);
                fwAdmin.readConfigFile(netif.getIfname(), true);
                List rules = fwAdmin.getNetAppFirewallRules(netif.getIfname());
                netif.setFirewallRules(rules);
            }
        }
        catch (FirewallAdminException e) {
            Trace.trace(TRACE_MASKF, e);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, e);
        }
        int numLansBefore = this.networkIfs.size();
        int numLansNow = info.size();
        int j = 0;
        Trace.trace(TRACE_MASKT, "numLansBefore = " + numLansBefore + "; numLansNow = " + numLansNow);
        int i = 0;
        while (i < numLansBefore && j < numLansNow) {
            NetworkInterfaceInformation netif = (NetworkInterfaceInformation)this.networkIfs.get(i);
            NetworkInterfaceInformation infoNetif = (NetworkInterfaceInformation)info.get(j);
            infoNetif.setConfigured(netif.isConfigured());
            infoNetif.setPrivateIf(netif.isPrivateIf());
            infoNetif.setDhcpServer(netif.isDhcpServer());
            infoNetif.setDhcpClient(netif.isDhcpClient());
            infoNetif.setMediaSpeed(netif.getMediaSpeed());
            info.set(j, infoNetif);
            ++j;
            ++i;
        }
        Trace.trace(TRACE_MASKF, "<- NetworkSettings.getIPSettings()");
        return info;
    }

    private String executeScript(String[] script) {
        Trace.trace(TRACE_MASKT, "\nexecuteScript->");
        String cmdResults = new String("");
        String errorResults = new String("");
        try {
            String errorLine;
            String line;
            Process pid = RootProcess.startProgram(script);
            BufferedReader in = new BufferedReader(new InputStreamReader(pid.getInputStream()));
            do {
                if ((line = in.readLine()) == null) continue;
                Trace.trace(TRACE_MASKF, "Output: line = " + line);
                cmdResults = cmdResults + line + "\n";
            } while (line != null);
            BufferedReader inError = new BufferedReader(new InputStreamReader(pid.getErrorStream()));
            do {
                if ((errorLine = inError.readLine()) == null) continue;
                Trace.trace(TRACE_MASKF, "\nERROR: line = " + errorLine);
                errorResults = errorResults + " " + errorLine;
            } while (errorLine != null);
        }
        catch (IOException e) {
            System.out.println("caught IOException: " + e.getMessage());
            e.printStackTrace();
        }
        catch (Throwable e) {
            System.out.println("caught Exception: " + e.getMessage());
            e.printStackTrace();
        }
        return cmdResults;
    }

    private String readMultipleFileContents(ArrayList fileNames) {
        Trace.trace(TRACE_MASKT, "readMultipleFileContents->");
        String[] files = new String[fileNames.size() + 1];
        ListIterator iterator = fileNames.listIterator();
        files[0] = CATNETWORKFILES;
        int i = 1;
        while (iterator.hasNext()) {
            files[i] = (String)iterator.next();
            ++i;
        }
        String commandResults = this.executeScript(files);
        Trace.trace(TRACE_MASKT, "readMultipleFileContents<-");
        return commandResults;
    }

    private String[] getCommandArray(String command) {
        Trace.trace(TRACE_MASKT, "getCommandArray -> will execute command [" + command.toString() + "]");
        String[] commandArray = new String[]{"bash", "-c", command};
        return commandArray;
    }

    private String getFileContents(String fileName, String allFileContents) {
        String contents = "";
        String startLine = "FILE NAME:***" + fileName + "***";
        int startIdx = allFileContents.indexOf(startLine);
        if (startIdx != -1) {
            int endIdx = allFileContents.indexOf("FILE NAME:***", startIdx = startIdx + startLine.length() + 1);
            if (endIdx == -1) {
                endIdx = allFileContents.length();
            }
            contents = allFileContents.substring(startIdx, endIdx);
        }
        Trace.trace(TRACE_MASKT, "Contents of file [" + fileName + "]: [\n" + contents + "]\n");
        return contents;
    }

    private boolean getDhcpClientSetting(String ifname, String allFileContents) {
        boolean dhcp = false;
        String tmp = this.getFileContents(DIRECTORY + PREFIX + ifname, allFileContents);
        int index = tmp.indexOf("BOOTPROTO");
        if (index != -1) {
            String dhcpClient = tmp.substring(tmp.indexOf("BOOTPROTO"));
            if ((dhcpClient = dhcpClient.substring(dhcpClient.indexOf("=") + 1).trim()).indexOf("dhcp") != -1) {
                dhcp = true;
            }
            Trace.trace(TRACE_MASKF, "BOOTPROTO = " + dhcpClient + "; dhcpClient set to [" + dhcp + "]");
        } else {
            dhcp = true;
            Trace.trace(TRACE_MASKF, "BOOTPROTO not found; dhcp set to [" + dhcp + "]");
        }
        return dhcp;
    }

    private String getValue(String key, String fileName) {
        String value = "";
        String tmp = fileName;
        int index = tmp.indexOf(key);
        if (index != -1) {
            value = tmp.substring(index);
            value = value.indexOf("\n") != -1 ? value.substring(value.indexOf("=") + 1, value.indexOf("\n")).trim() : value.substring(value.indexOf("=") + 1).trim();
            if (value.startsWith("\"") || value.startsWith("'")) {
                value = value.substring(1);
            }
            if (value.endsWith("\"") || value.endsWith("'")) {
                value = value.substring(0, value.length() - 1);
            }
            Trace.trace(TRACE_MASKF, key + " =  [" + value.trim() + "]");
        } else {
            Trace.trace(TRACE_MASKF, key + " not found; " + value + " set to [" + value + "]");
        }
        return value.trim();
    }

    private void prepareFileRewrite(String fileName, String newContents, String oldContents, ArrayList filesToCopy, ArrayList filesToDelete) throws IOException {
        if (!(newContents = newContents.trim()).equals(oldContents = oldContents.trim())) {
            Trace.trace(TRACE_MASKF, fileName + " Contents DIFFERENT!");
            Trace.trace(TRACE_MASKF, "  OldContents = [\n" + oldContents + "]\n");
            Trace.trace(TRACE_MASKF, "  Replace with: [\n" + newContents + "]\n");
            File tmpf = File.createTempFile(TEMP_PATH_KEY, "", TEMP_DIR);
            FileWriter fw = new FileWriter(tmpf);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(newContents + "\n");
            bw.close();
            String[] filePairs = new String[]{tmpf.getPath(), fileName};
            filesToCopy.add(filePairs);
            filesToDelete.add(tmpf);
        } else {
            Trace.trace(TRACE_MASKF, fileName + " Contents UNCHANGED!");
        }
    }

    public static synchronized String[] getSpeeds() {
        String bundleName = "com.ibm.hwmca.base.settings.network.res.NetworkRes";
        SPEEDS = new String[7];
        try {
            ResourceBundle rb = ResourceBundle.getBundle(bundleName);
            Locale serverLoc = Locale.getDefault();
            UserContext userContext = UserContext.getCurrentUserContext();
            Locale clientLoc = userContext.getLocale();
            NetworkSettings.SPEEDS[0] = new LocalizableText(bundleName, "IPAddressPanel.Value1.VALUE").toString(clientLoc);
            NetworkSettings.SPEEDS[1] = new LocalizableText(bundleName, "IPAddressPanel.Value2.VALUE").toString(clientLoc);
            NetworkSettings.SPEEDS[2] = new LocalizableText(bundleName, "IPAddressPanel.Value3.VALUE").toString(clientLoc);
            NetworkSettings.SPEEDS[3] = new LocalizableText(bundleName, "IPAddressPanel.Value4.VALUE").toString(clientLoc);
            NetworkSettings.SPEEDS[4] = new LocalizableText(bundleName, "IPAddressPanel.Value5.VALUE").toString(clientLoc);
            NetworkSettings.SPEEDS[5] = new LocalizableText(bundleName, "IPAddressPanel.Value6.VALUE").toString(clientLoc);
            NetworkSettings.SPEEDS[6] = new LocalizableText(bundleName, "IPAddressPanel.Value7.VALUE").toString(clientLoc);
            Trace.trace(TRACE_MASKT, "Server Locale: " + serverLoc.toString() + "; ClientLocale = " + clientLoc);
            Trace.trace(TRACE_MASKT, "getSpeeds w/ResourceBundle: SPEEDS[0] = " + SPEEDS[0]);
        }
        catch (MissingResourceException e) {
            Trace.trace(TRACE_MASKF, "NetworkSettings unable to retrieve medias speeed pulldown labels from ResourceBundle " + bundleName);
            NetworkSettings.SPEEDS[0] = "Autodetection";
            NetworkSettings.SPEEDS[1] = "10Mbps Half Duplex";
            NetworkSettings.SPEEDS[2] = "10Mbps Full Duplex";
            NetworkSettings.SPEEDS[3] = "100Mbps Half Duplex";
            NetworkSettings.SPEEDS[4] = "100Mbps Full Duplex";
            NetworkSettings.SPEEDS[5] = "1000Mbps Half Duplex";
            NetworkSettings.SPEEDS[6] = "1000Mbps Full Duplex";
            Trace.trace(TRACE_MASKT, "getSpeeds NO ResourceBundle: SPEEDS[0] = " + SPEEDS[0]);
        }
        return SPEEDS;
    }

    public static synchronized String getCorrectedMediaSpeed(String ms, boolean isGetIPSettings) {
        Trace.trace(TRACE_MASKT, "-> getCorrectedMediaSpeed: " + isGetIPSettings);
        NetworkSettings.getSpeeds();
        String tms = ms;
        if (isGetIPSettings) {
            try {
                int i = Integer.parseInt(ms);
                tms = SPEEDS[i];
            }
            catch (NumberFormatException e) {}
        } else {
            tms = "0";
            int i = 0;
            while (i < SPEEDS.length) {
                if (ms.trim().length() > 0) {
                    Trace.trace(TRACE_MASKT, "ms = [" + ms + "]; SPEEDS[" + i + "] = " + SPEEDS[i]);
                    if (ms.equals(SPEEDS[i])) {
                        tms = Integer.toString(i);
                        break;
                    }
                } else {
                    tms = "0";
                    break;
                }
                ++i;
            }
        }
        Trace.trace(TRACE_MASKT, "<- getCorrectedMediaSpeed: was " + ms + "; now " + tms);
        return tms;
    }

    public static String handleMultiple(String thisDriver, List eths, String e100Options, String eepro100Options, String e1000Options, String bcm5700Options, String[] mode, String[] duplex, String[] speed) {
        Trace.trace(TRACE_MASKT, "-> handleMultiple(" + eths.size() + "): thisDriver = " + thisDriver);
        String returnString = "";
        int numEths = eths.size();
        int[] index = new int[numEths];
        int j = 0;
        while (j < eths.size()) {
            String temp = (String)eths.get(j);
            Integer I = Integer.valueOf(temp);
            index[j] = I;
            ++j;
        }
        if (thisDriver.equals("e100")) {
            returnString = returnString + "options e100";
            returnString = returnString + e100Options;
            returnString = returnString + " e100_speed_duplex=";
            returnString = returnString + mode[index[0]];
            int j2 = 1;
            while (j2 < numEths) {
                returnString = returnString + ",";
                returnString = returnString + mode[index[j2]];
                ++j2;
            }
            returnString = returnString + "\n";
        } else if (thisDriver.equals("eepro100")) {
            returnString = returnString + "options eepro100";
            returnString = returnString + eepro100Options;
            returnString = returnString + " options=";
            returnString = returnString + mode[index[0]];
            int j3 = 1;
            while (j3 < numEths) {
                returnString = returnString + ",";
                returnString = returnString + mode[index[j3]];
                ++j3;
            }
            returnString = returnString + "\n";
        } else if (thisDriver.equals("e1000")) {
            returnString = returnString + "options e1000";
            returnString = returnString + e1000Options;
            returnString = returnString + " Duplex=";
            returnString = returnString + duplex[index[0]];
            int j4 = 1;
            while (j4 < numEths) {
                returnString = returnString + ",";
                returnString = returnString + duplex[index[j4]];
                ++j4;
            }
            returnString = returnString + " Speed=";
            returnString = returnString + speed[index[0]];
            int j5 = 1;
            while (j5 < numEths) {
                returnString = returnString + ",";
                returnString = returnString + speed[index[j5]];
                ++j5;
            }
            returnString = returnString + "\n";
        } else if (thisDriver.equals("bcm5700")) {
            returnString = returnString + "options bcm5700";
            returnString = returnString + bcm5700Options;
            returnString = returnString + " line_speed=";
            returnString = returnString + speed[index[0]];
            int j6 = 1;
            while (j6 < numEths) {
                returnString = returnString + ",";
                returnString = returnString + speed[index[j6]];
                ++j6;
            }
            returnString = returnString + " full_duplex=";
            returnString = returnString + duplex[index[0]];
            int j7 = 1;
            while (j7 < numEths) {
                returnString = returnString + ",";
                returnString = returnString + duplex[index[j7]];
                ++j7;
            }
            returnString = returnString + "\n";
        } else if (thisDriver.equals("tg3")) {
            int j8 = 0;
            while (j8 < numEths) {
                returnString = returnString + ETHTOOL_PREFIX;
                if (speed[index[j8]].equals("0")) {
                    returnString = returnString + "eth" + index[j8] + " autoneg on\n";
                } else {
                    returnString = returnString + "eth" + index[j8] + " autoneg off speed ";
                    returnString = returnString + speed[index[j8]];
                    returnString = returnString + " duplex ";
                    returnString = returnString + duplex[index[j8]];
                    returnString = returnString + "\n";
                }
                ++j8;
            }
        }
        Trace.trace(TRACE_MASKT, "<- handleMultiple()");
        return returnString;
    }

    public static String handleIndividual(String thisDriver, List eths, String e100Options, String eepro100Options, String e1000Options, String bcm5700Options, String[] mode, String[] duplex, String[] speed) {
        Trace.trace(TRACE_MASKT, "-> handleIndividual(): thisDriver = " + thisDriver);
        String returnString = "";
        int j = 0;
        String temp = (String)eths.get(j);
        Integer I = Integer.valueOf(temp);
        int i = I;
        if (thisDriver.equals("e100")) {
            returnString = returnString + "options e100";
            returnString = returnString + e100Options;
            returnString = returnString + " e100_speed_duplex=";
            returnString = returnString + mode[i];
            returnString = returnString + "\n";
        } else if (thisDriver.equals("eepro100")) {
            returnString = returnString + "options eepro100";
            returnString = returnString + eepro100Options;
            returnString = returnString + " options=";
            returnString = returnString + mode[i];
            returnString = returnString + "\n";
        } else if (thisDriver.equals("e1000")) {
            returnString = returnString + "options e1000";
            returnString = returnString + e1000Options;
            returnString = returnString + " Duplex=";
            returnString = returnString + duplex[i];
            returnString = returnString + " Speed=";
            returnString = returnString + speed[i];
            returnString = returnString + "\n";
        } else if (thisDriver.equals("bcm5700")) {
            returnString = returnString + "options bcm5700";
            returnString = returnString + bcm5700Options;
            returnString = returnString + " line_speed=";
            returnString = returnString + speed[i];
            returnString = returnString + " full_duplex=";
            returnString = returnString + duplex[i];
            returnString = returnString + "\n";
        } else if (thisDriver.equals("tg3")) {
            returnString = returnString + ETHTOOL_PREFIX;
            if (speed[i].equals("0")) {
                returnString = returnString + "eth" + i + " autoneg on\n";
            } else {
                returnString = returnString + "eth" + i + " autoneg off speed ";
                returnString = returnString + speed[i];
                returnString = returnString + " duplex ";
                returnString = returnString + duplex[i];
                returnString = returnString + "\n";
            }
        }
        Trace.trace(TRACE_MASKT, "<- handleIndividual()");
        return returnString;
    }

    private String getInstalledCards() {
        Trace.trace(TRACE_MASKD, "->NetworkSettings.getInstalledCards()");
        String commandSeparator = "***RESULTS OF LS COMMAND***";
        String[] setIfcfgParms = new String[]{RUNIFCFGS, DIRECTORY};
        Trace.trace(TRACE_MASKF, "setIfcfgParms: " + setIfcfgParms[1]);
        String commandResults = this.executeScript(setIfcfgParms);
        Trace.trace(TRACE_MASKF, "commandResults = [" + commandResults + "]");
        int separatorIdx = commandResults.indexOf(commandSeparator);
        String lsResults = "";
        if (separatorIdx != -1) {
            ifconfigResults = commandResults.substring(0, separatorIdx);
            lsResults = commandResults.substring(separatorIdx + commandSeparator.length() + 1);
        }
        Trace.trace(TRACE_MASKF, "\nifconfigResults = " + ifconfigResults);
        Trace.trace(TRACE_MASKF, "\nlsResults = " + lsResults);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.indexOf(".") == -1 && (name.indexOf("ifcfg-eth") != -1 || name.indexOf("ifcfg-tr") != -1);
            }
        };
        File dir = new File(DIRECTORY);
        StringTokenizer lsResultsTokenizer = new StringTokenizer(lsResults);
        ArrayList<String> fileNames = new ArrayList<String>();
        while (lsResultsTokenizer.hasMoreTokens()) {
            String next = lsResultsTokenizer.nextToken();
            if (!filter.accept(dir, next)) continue;
            fileNames.add(next);
            Trace.trace(TRACE_MASKF, "Adding network adapter ifcfg-" + next + " to the list of files");
        }
        fileNames.add(NETWORK_FILE);
        allFileContents = this.readMultipleFileContents(fileNames);
        Trace.trace(TRACE_MASKD, "allFileContents = [" + allFileContents + "]");
        Trace.trace(TRACE_MASKD, "<-NetworkSettings.getInstalledCards()");
        return allFileContents;
    }

    public void mergePersistedNetworkSettings() {
        Trace.trace(TRACE_MASKT, "-> NetworkSettings.mergePersistedNetworkSettings()");
        try {
            NetworkSettings persistedNetworkSettings = (NetworkSettings)PersistenceManager.getPersistenceManager().read(persistKey);
            boolean changesMade = false;
            boolean persistedEmpty = false;
            int numLans = this.networkIfs.size();
            if (numLans > 0 && persistedNetworkSettings == null) {
                int i = 0;
                while (i < numLans) {
                    NetworkInterfaceInformation netif = (NetworkInterfaceInformation)this.networkIfs.get(i);
                    if (netif.isDhcpClient()) {
                        Trace.trace(TRACE_MASKT, "New lan - never persisted before, running dhcp client");
                        changesMade = true;
                    }
                    ++i;
                }
            }
            if (persistedNetworkSettings != null) {
                int i;
                this.visibleIfs = persistedNetworkSettings.getVisibleIfs();
                this.networkInfo.setComputerDescription(persistedNetworkSettings.networkInfo.getComputerDescription());
                this.networkInfo.setRoutedEnabled(persistedNetworkSettings.networkInfo.isRoutedEnabled());
                this.networkInfo.setDNSEnabled(persistedNetworkSettings.networkInfo.isDNSEnabled());
                if (this.networkInfo.getDNSServers().length == 0 && persistedNetworkSettings.networkInfo.getDNSServers().length > 0) {
                    this.networkInfo.setDNSServers(persistedNetworkSettings.networkInfo.getDNSServers());
                    Trace.trace(TRACE_MASKF, "Overlay DNDServers with persisted values");
                    changesMade = true;
                }
                if (this.networkInfo.getDomainSuffixes().length == 0 && persistedNetworkSettings.networkInfo.getDomainSuffixes().length > 0) {
                    this.networkInfo.setDomainSuffixes(persistedNetworkSettings.networkInfo.getDomainSuffixes());
                    Trace.trace(TRACE_MASKF, "Overlay DomainSuffixes with persisted values");
                    changesMade = true;
                }
                if (this.networkInfo.getDefaultGateway().length() == 0 && persistedNetworkSettings.networkInfo.getDefaultGateway().length() > 0) {
                    this.networkInfo.setDefaultGateway(persistedNetworkSettings.networkInfo.getDefaultGateway());
                    this.networkInfo.setGatewayDev(persistedNetworkSettings.networkInfo.getGatewayDev());
                    Trace.trace(TRACE_MASKF, "Overlay DefaultGateway and GatewayDev with persisted values");
                    changesMade = true;
                }
                List persistedNetworkInterfaceInfo = persistedNetworkSettings.getNetworkInterfaceInfo();
                numLans = this.networkIfs.size();
                int persNumLans = persistedNetworkInterfaceInfo.size();
                Trace.trace(TRACE_MASKF, "Found " + numLans + " lans; Persisted " + persNumLans + " lans");
                if (numLans > 0 && persNumLans == 0) {
                    i = 0;
                    while (i < numLans) {
                        NetworkInterfaceInformation netif = (NetworkInterfaceInformation)this.networkIfs.get(i);
                        if (netif.isDhcpClient()) {
                            Trace.trace(TRACE_MASKT, "New lan - never persisted before, running dhcp client");
                            changesMade = true;
                        }
                        ++i;
                    }
                }
                if (numLans > persNumLans) {
                    numLans = persNumLans;
                }
                if (numLans > 0) {
                    i = 0;
                    while (i < numLans) {
                        NetworkInterfaceInformation persNetif = (NetworkInterfaceInformation)persistedNetworkInterfaceInfo.get(i);
                        NetworkInterfaceInformation netif = (NetworkInterfaceInformation)this.networkIfs.get(i);
                        netif.setConfigured(persNetif.isConfigured());
                        netif.setPrivateIf(persNetif.isPrivateIf());
                        netif.setDhcpServer(persNetif.isDhcpServer());
                        netif.setDhcpClient(persNetif.isDhcpClient());
                        netif.setMediaSpeed(persNetif.getMediaSpeed());
                        netif.setPartitionCommunication(persNetif.isPartitionCommunication());
                        Trace.trace(TRACE_MASKT, "netif[" + i + "]  persNetif.isConfigured: " + netif.isConfigured() + "]");
                        Trace.trace(TRACE_MASKT, "netif[" + i + "]  persNetif.isPrivateIf: " + netif.isPrivateIf() + "]");
                        Trace.trace(TRACE_MASKT, "netif[" + i + "]  persNetif.isDhcpServer: " + netif.isDhcpServer() + "]");
                        Trace.trace(TRACE_MASKT, "netif[" + i + "]  persNetif.isDhcpClient: " + netif.isDhcpClient() + "]");
                        Trace.trace(TRACE_MASKT, "netif[" + i + "]  persNetif.getMediaSpeed: " + netif.getMediaSpeed() + "]");
                        Trace.trace(TRACE_MASKT, "netif[" + i + "]  persNetif.isPartitionCommunication: " + netif.isPartitionCommunication() + "]");
                        ++i;
                    }
                }
                if (!this.networkInfo.getPlatform().equals("PHMC")) {
                    Trace.trace(TRACE_MASKT, "Old hostname = [" + persistedNetworkSettings.getNetworkInfo().getComputerName() + "]");
                    Trace.trace(TRACE_MASKT, "New hostname = [" + this.networkInfo.getComputerName() + "]");
                    if (!persistedNetworkSettings.networkInfo.getComputerName().equals(this.networkInfo.getComputerName()) || !persistedNetworkSettings.networkInfo.getDomainName().equals(this.networkInfo.getDomainName())) {
                        this.networkInfo.setComputerName(persistedNetworkSettings.networkInfo.getComputerName());
                        this.networkInfo.setDomainName(persistedNetworkSettings.networkInfo.getDomainName());
                        changesMade = true;
                    }
                    Trace.trace(TRACE_MASKT, "changesMade = " + changesMade + "; Old hostname = [" + persistedNetworkSettings.networkInfo.getComputerName() + "." + persistedNetworkSettings.networkInfo.getDomainName() + "]; hostname found now = [" + this.networkInfo.getComputerName() + "." + this.networkInfo.getDomainName() + "]");
                    changesMade = this.mergeInterfaceSettings(persistedNetworkSettings.networkIfs) || changesMade;
                    String[] dnsValues = this.networkInfo.getDNSServers();
                    String[] persistedDnsvaluess = persistedNetworkSettings.networkInfo.getDNSServers();
                    String[] domainSuffixes = this.networkInfo.getDomainSuffixes();
                    String[] persistedDomainSuffixes = persistedNetworkSettings.networkInfo.getDomainSuffixes();
                    changesMade = dnsValues.length == persistedDnsvaluess.length && domainSuffixes.length == persistedDomainSuffixes.length ? changesMade || this.compareNetworkInfo(persistedNetworkSettings.networkInfo) : true;
                    if (changesMade) {
                        this.networkInfo.setDNSServers(persistedNetworkSettings.networkInfo.getDNSServers());
                        this.networkInfo.setDomainSuffixes(persistedNetworkSettings.networkInfo.getDomainSuffixes());
                        this.networkInfo.setDefaultGateway(persistedNetworkSettings.networkInfo.getDefaultGateway());
                        this.networkInfo.setGatewayDev(persistedNetworkSettings.networkInfo.getGatewayDev());
                    }
                    Trace.trace(TRACE_MASKT, "mergePersistedNetworkSettings: changesMade = " + changesMade);
                    int i2 = 0;
                    while (i2 < persistedDomainSuffixes.length) {
                        Trace.trace(TRACE_MASKT, " domainSuffixes[" + i2 + "] = " + this.networkInfo.getDomainSuffixes()[i2]);
                        ++i2;
                    }
                    int i3 = 0;
                    while (i3 < persistedDnsvaluess.length) {
                        Trace.trace(TRACE_MASKT, " dnsvalues[" + i3 + "] = " + this.networkInfo.getDNSServers()[i3]);
                        ++i3;
                    }
                    Trace.trace(TRACE_MASKT, "defaultGateway = " + this.networkInfo.getDefaultGateway());
                    Trace.trace(TRACE_MASKT, "gatewayDev = " + this.networkInfo.getGatewayDev());
                }
            } else {
                persistedEmpty = true;
                Trace.trace(TRACE_MASKT, "No persisted NetSettings, persist them now");
            }
            if (changesMade || persistedEmpty) {
                PersistenceManager.getPersistenceManager().write(persistKey, this);
            }
            if (changesMade) {
                Trace.trace(TRACE_MASKT, "Changes were made. Apply the new settings");
                this.setNetworkInfo(this.networkInfo);
                this.updateConfigFiles();
                this.networkRestart();
            }
        }
        catch (PersistenceException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc + " mergePersistedNetworkSettings terminated.");
            exc.printStackTrace();
            HException hexc = new HException(exc);
            new FrameworkLog(_logInfo, 16, hexc).log();
        }
        Trace.trace(TRACE_MASKT, "<- NetworkSettings.mergePersistedNetworkSettings()");
    }

    private boolean mergeInterfaceSettings(List persistNetworkIfs) {
        Trace.trace(TRACE_MASKT, "-> NetworkSettings.mergeInterfaceSettings()");
        boolean changesMade = false;
        NetworkInterfaceInformation persistNetif0 = new NetworkInterfaceInformation();
        NetworkInterfaceInformation persistNetif1 = new NetworkInterfaceInformation();
        NetworkInterfaceInformation environNetif0 = new NetworkInterfaceInformation();
        NetworkInterfaceInformation environNetif1 = new NetworkInterfaceInformation();
        int persistNumCards = persistNetworkIfs.size();
        int environNumCards = this.networkIfs.size();
        Trace.trace(TRACE_MASKT, "persistNumCards = " + persistNumCards + "; environNumCards = " + environNumCards);
        ArrayList mergedNetworkIfs = new ArrayList(environNumCards);
        NetworkInterfaceInformation mergedNetif0 = new NetworkInterfaceInformation();
        NetworkInterfaceInformation mergedNetif1 = new NetworkInterfaceInformation();
        if (persistNumCards > 0) {
            persistNetif0 = (NetworkInterfaceInformation)persistNetworkIfs.get(0);
            if (persistNumCards > 1) {
                persistNetif1 = (NetworkInterfaceInformation)persistNetworkIfs.get(1);
            }
        }
        if (environNumCards > 0) {
            mergedNetif0 = (NetworkInterfaceInformation)this.networkIfs.get(0);
            environNetif0 = (NetworkInterfaceInformation)this.networkIfs.get(0);
            if (environNumCards > 1) {
                mergedNetif1 = (NetworkInterfaceInformation)this.networkIfs.get(1);
                environNetif1 = (NetworkInterfaceInformation)this.networkIfs.get(1);
            }
        }
        int i = 0;
        while (i < this.networkIfs.size()) {
            mergedNetworkIfs.add(this.networkIfs.get(i));
            ++i;
        }
        if (persistNumCards == environNumCards && environNumCards == 1) {
            if (this.compareNetifs(persistNetif0, environNetif0)) {
                Trace.trace(TRACE_MASKT, "One card; same as it was before; No change needed");
            } else {
                Trace.trace(TRACE_MASKT, "One card; differences found; Use persisted values where appropriate.");
                mergedNetif0 = this.updateNetif(persistNetif0, environNetif0);
                changesMade = true;
            }
        } else if (persistNumCards == 1 && environNumCards == 2) {
            Trace.trace(TRACE_MASKT, "1 Old;2 New;");
            int oldType = persistNetif0.getAdapterType();
            int firstNewType = environNetif0.getAdapterType();
            int secondNewType = environNetif1.getAdapterType();
            changesMade = true;
            if (oldType == firstNewType) {
                Trace.trace(TRACE_MASKT, "1 Old;2 New; oldType = firstNewType = " + persistNetif0.getIfname());
                mergedNetif0 = this.updateNetif(persistNetif0, environNetif0);
                mergedNetif1 = environNetif1;
            } else if (oldType == secondNewType) {
                Trace.trace(TRACE_MASKT, "1 Old;2 New; oldType = secondNewType = " + persistNetif0.getIfname());
                mergedNetif1 = this.updateNetif(persistNetif0, environNetif1);
                mergedNetif0 = environNetif0;
            } else {
                Trace.trace(TRACE_MASKT, "1 Old;2 New; Both new ones different. Oldtype = " + persistNetif0.getIfname() + " firstNewType = " + firstNewType + " secondNewType = " + secondNewType);
                mergedNetif0 = this.updateNetif(persistNetif0, environNetif0);
                mergedNetif1 = environNetif1;
            }
        } else if (persistNumCards == 2 && environNumCards == 1) {
            Trace.trace(TRACE_MASKT, "2 Old;1 New;");
            int firstOldType = persistNetif0.getAdapterType();
            int secondOldType = persistNetif1.getAdapterType();
            int newType = environNetif0.getAdapterType();
            changesMade = true;
            if (firstOldType == newType) {
                Trace.trace(TRACE_MASKT, "2 Old;1 New; firstOldType = newType = " + persistNetif0.getIfname());
                mergedNetif0 = this.updateNetif(persistNetif0, environNetif0);
            } else if (secondOldType == newType) {
                Trace.trace(TRACE_MASKT, "2 Old;1 New; secondOldType = newType = " + persistNetif1.getIfname());
                mergedNetif0 = this.updateNetif(persistNetif1, environNetif0);
            } else {
                Trace.trace(TRACE_MASKT, "2 Old;1 New; Both old ones different. firstOldType = " + persistNetif0.getIfname() + " secondOldType = " + secondOldType + " newType = " + newType);
                mergedNetif0 = this.updateNetif(persistNetif0, environNetif0);
            }
        } else if (persistNumCards == 2 && environNumCards == 2) {
            Trace.trace(TRACE_MASKT, "2 Old;2 New;");
            if (this.compareNetifs(persistNetif0, environNetif0) && this.compareNetifs(persistNetif1, environNetif1)) {
                Trace.trace(TRACE_MASKT, "Two cards; both same as they were before; No change needed");
            } else {
                int firstOldType = persistNetif0.getAdapterType();
                int secondOldType = persistNetif1.getAdapterType();
                int firstNewType = environNetif0.getAdapterType();
                int secondNewType = environNetif1.getAdapterType();
                changesMade = true;
                if (firstOldType == firstNewType) {
                    Trace.trace(TRACE_MASKT, "2 Old;2 New; firstOldType = firstNewType = " + persistNetif0.getIfname());
                    mergedNetif0 = this.updateNetif(persistNetif0, environNetif0);
                    mergedNetif1 = this.updateNetif(persistNetif1, environNetif1);
                } else if (secondOldType == firstNewType) {
                    Trace.trace(TRACE_MASKT, "2 Old;2 New; secondOldType = firstNewType = " + persistNetif1.getIfname());
                    mergedNetif0 = this.updateNetif(persistNetif1, environNetif0);
                    mergedNetif1 = this.updateNetif(persistNetif0, environNetif1);
                } else {
                    Trace.trace(TRACE_MASKT, "2 Old;2 New; Both old ones different. firstOldType = " + persistNetif0.getIfname() + " secondOldType = " + secondOldType + " firstNewType = " + firstNewType + " secondNewType = " + secondNewType);
                    mergedNetif0 = this.updateNetif(persistNetif0, environNetif0);
                    mergedNetif1 = this.updateNetif(persistNetif1, environNetif1);
                }
            }
        }
        if (environNumCards >= 1) {
            if (mergedNetworkIfs.size() > 0) {
                mergedNetworkIfs.set(0, mergedNetif0);
            } else {
                mergedNetworkIfs.add(0, mergedNetif0);
            }
        }
        if (environNumCards == 2) {
            if (mergedNetworkIfs.size() > 1) {
                mergedNetworkIfs.set(1, mergedNetif1);
            } else {
                mergedNetworkIfs.add(1, mergedNetif1);
            }
        }
        this.networkIfs = mergedNetworkIfs;
        Trace.trace(TRACE_MASKT, "<- NetworkSettings.mergeInterfaceSettings(), changesMade = " + changesMade);
        return changesMade;
    }

    private boolean compareNetworkInfo(NetworkInfo persistNetworkInfo) {
        Trace.trace(TRACE_MASKT, "-> NetworkSettings.compareNetworkInfo()");
        boolean changesMade = false;
        boolean done = false;
        String[] dnsValues = this.networkInfo.getDNSServers();
        String[] persistedDnsvalues = persistNetworkInfo.getDNSServers();
        String[] domainSuffixes = this.networkInfo.getDomainSuffixes();
        String[] persistedDomainSuffixes = persistNetworkInfo.getDomainSuffixes();
        String defaultGateway = this.networkInfo.getDefaultGateway();
        String persistedDefaultGateway = persistNetworkInfo.getDefaultGateway();
        String gatewayDev = this.networkInfo.getGatewayDev();
        String persistedGatewayDev = persistNetworkInfo.getGatewayDev();
        int i = 0;
        while (i < dnsValues.length && !done) {
            Trace.trace(TRACE_MASKT, " dnsValues[" + i + "] = [" + dnsValues[i] + "]; persistedDnsvalues[" + i + "] = [" + persistedDnsvalues[i] + "]");
            if (!dnsValues[i].equals(persistedDnsvalues[i])) {
                changesMade = true;
                done = true;
            }
            ++i;
        }
        done = false;
        int i2 = 0;
        while (i2 < domainSuffixes.length && !done && !changesMade) {
            Trace.trace(TRACE_MASKT, " domainSuffixes[" + i2 + "] = " + domainSuffixes[i2] + "; persistedDomainSuffixes[" + i2 + "] = " + persistedDomainSuffixes[i2]);
            if (!domainSuffixes[i2].equals(persistedDomainSuffixes[i2])) {
                changesMade = true;
                done = true;
            }
            ++i2;
        }
        if (!changesMade && !defaultGateway.equals(persistedDefaultGateway)) {
            Trace.trace(TRACE_MASKT, " defaultGateway = " + defaultGateway + "; persistedDefaultGateway = " + persistedDefaultGateway);
            changesMade = true;
        }
        if (!changesMade && !gatewayDev.equals(persistedGatewayDev)) {
            Trace.trace(TRACE_MASKT, " gatewayDev = " + gatewayDev + "; persistedGatewayDev = " + persistedGatewayDev);
            changesMade = true;
        }
        Trace.trace(TRACE_MASKT, "<- NetworkSettings.compareNetworkInfo(), changesMade = " + changesMade);
        return changesMade;
    }

    private boolean compareNetifs(NetworkInterfaceInformation netIf1, NetworkInterfaceInformation netIf2) {
        Trace.trace(TRACE_MASKD, "-> NetworkSettings.compareNetifs()");
        boolean comparison = true;
        if (!netIf1.getIpAddr().equals(netIf2.getIpAddr())) {
            Trace.trace(TRACE_MASKD, "IPAddresses different: " + netIf1.getIpAddr() + " and " + netIf2.getIpAddr());
            comparison = false;
        } else if (!netIf1.getNetMask().equals(netIf2.getNetMask())) {
            Trace.trace(TRACE_MASKD, "NetworkMasks different: " + netIf1.getNetMask() + " and " + netIf2.getNetMask());
            comparison = false;
        } else if (netIf1.isDhcpClient() != netIf2.isDhcpClient()) {
            Trace.trace(TRACE_MASKD, "DHCPClient values different: " + netIf1.isDhcpClient() + " and " + netIf2.isDhcpClient());
            comparison = false;
        } else if (netIf1.isPrivateIf() != netIf2.isPrivateIf()) {
            Trace.trace(TRACE_MASKD, "isPrivateIf values different: " + netIf1.isPrivateIf() + " and " + netIf2.isPrivateIf());
            comparison = false;
        } else if (netIf1.isDhcpServer() != netIf2.isDhcpServer()) {
            Trace.trace(TRACE_MASKD, "DHCPServer values different: " + netIf1.isDhcpServer() + " and " + netIf2.isDhcpServer());
            comparison = false;
        } else if (netIf1.getMediaSpeed() != null) {
            if (!netIf1.getMediaSpeed().equals(netIf2.getMediaSpeed())) {
                Trace.trace(TRACE_MASKD, "MediaSpeeds different: " + netIf1.getMediaSpeed() + " and " + netIf2.getMediaSpeed());
                comparison = false;
            }
        } else {
            Trace.trace(TRACE_MASKD, "Oops media speed is null.  How did this happen?");
        }
        Trace.trace(TRACE_MASKD, "<- NetworkSettings.compareNetifs()");
        return comparison;
    }

    private int setMtuValue(String s) {
        Trace.trace(TRACE_MASKD, "-> NetworkSettings.setMtuValue(); s = [" + s + "]");
        int mtuValue = 0;
        int defaultVal = 1500;
        int pos = s.indexOf("=") + 1;
        String temp = s.substring(pos);
        pos = temp.indexOf("'");
        if (-1 != pos) {
            Trace.trace(TRACE_MASKD, "Found a ' character");
            int posLast = temp.lastIndexOf("'");
            if (posLast - pos > 1 && (temp = temp.substring(pos + 1, posLast).trim()).length() > 0) {
                mtuValue = new Integer(temp);
                Trace.trace(TRACE_MASKD, "ingeger value = [" + mtuValue + "]");
            }
        } else {
            pos = temp.indexOf("\"");
            if (-1 != pos) {
                Trace.trace(TRACE_MASKD, "Found a \" character");
                int posLast = temp.lastIndexOf("\"");
                if (posLast - pos > 1 && (temp = temp.substring(pos + 1, posLast).trim()).length() > 0) {
                    mtuValue = new Integer(temp);
                    Trace.trace(TRACE_MASKD, "ingeger value = [" + mtuValue + "]");
                }
            }
        }
        if (mtuValue > 0) {
            Trace.trace(TRACE_MASKD, "Keep old mtuValue: [" + mtuValue + "]");
        } else {
            Trace.trace(TRACE_MASKD, "No mtuValue found; set default");
            mtuValue = defaultVal;
        }
        Trace.trace(TRACE_MASKD, "<- NetworkSettings.setMtuValue(): [" + mtuValue + "]");
        return mtuValue;
    }

    private NetworkInterfaceInformation updateNetif(NetworkInterfaceInformation perIf, NetworkInterfaceInformation envIf) {
        Trace.trace(TRACE_MASKD, "-> NetworkSettings.updateNetif()");
        Trace.trace(TRACE_MASKD, "IPAddress: " + perIf.getIpAddr() + " and " + envIf.getIpAddr());
        Trace.trace(TRACE_MASKD, "NetworkMask: " + perIf.getNetMask() + " and " + envIf.getNetMask());
        Trace.trace(TRACE_MASKD, "DHCP Client value: " + perIf.isDhcpClient() + " and " + envIf.isDhcpClient());
        Trace.trace(TRACE_MASKD, "privateIf value: " + perIf.isPrivateIf() + " and " + envIf.isPrivateIf());
        Trace.trace(TRACE_MASKD, "MediaSpeed: " + perIf.getMediaSpeed() + " and " + envIf.getMediaSpeed());
        Trace.trace(TRACE_MASKD, "DHCP Server value: " + perIf.isDhcpServer() + " and " + envIf.isDhcpServer());
        NetworkInterfaceInformation mergedNetif = new NetworkInterfaceInformation();
        mergedNetif.setIpAddress(perIf.getIpAddress());
        mergedNetif.setNetworkMask(perIf.getNetworkMask());
        mergedNetif.setAdapterType(envIf.getAdapterType());
        mergedNetif.setDhcpClient(perIf.isDhcpClient());
        mergedNetif.setPrivateIf(perIf.isPrivateIf());
        mergedNetif.setMediaSpeed(perIf.getMediaSpeed());
        mergedNetif.setDhcpServer(perIf.isDhcpServer());
        mergedNetif.setDhcpServerRangeConfig(perIf.getDhcpServerRangeConfig());
        mergedNetif.setIfname(envIf.getIfname());
        Trace.trace(TRACE_MASKD, "IPAddress replaced: " + envIf.getIpAddr() + " with " + mergedNetif.getIpAddr());
        Trace.trace(TRACE_MASKD, "NetworkMask replaced: " + envIf.getNetMask() + " with " + mergedNetif.getNetMask());
        Trace.trace(TRACE_MASKD, "DHCP Client value replaced: " + envIf.isDhcpClient() + " with " + mergedNetif.isDhcpClient());
        Trace.trace(TRACE_MASKD, "IsPrivateIf value replaced: " + envIf.isPrivateIf() + " with " + mergedNetif.isPrivateIf());
        Trace.trace(TRACE_MASKD, "MediaSpeed replaced: " + envIf.getMediaSpeed() + " with " + mergedNetif.getMediaSpeed());
        Trace.trace(TRACE_MASKD, "DHCP Server value replaced: " + envIf.isDhcpServer() + " with " + mergedNetif.isDhcpServer());
        Trace.trace(TRACE_MASKD, "<- NetworkSettings.updateNetif()");
        return mergedNetif;
    }

    public void startDHCPServer() {
        boolean found = false;
        int i = 0;
        while (i < this.networkIfs.size() && !found) {
            NetworkInterfaceInformation netif = (NetworkInterfaceInformation)this.networkIfs.get(i);
            Trace.trace(TRACE_MASKT, "netif.isConfigured() = " + netif.isConfigured());
            if (netif.isDhcpServer() && netif.isConfigured()) {
                Trace.trace(TRACE_MASKT, "Start DHCP Server for lan " + i);
                found = true;
                String[] dhcpParms = new String[]{STARTDHCPD};
                String commandResults = this.executeScript(dhcpParms);
                Trace.trace(TRACE_MASKF, "results of STARTDHCPD = [" + commandResults + "]");
            }
            ++i;
        }
        if (!found) {
            Trace.trace(TRACE_MASKT, "No DHCP Servers found");
        }
    }

    public void startRouted() {
        boolean routedEnabled = this.networkInfo.isRoutedEnabled();
        if (routedEnabled) {
            Trace.trace(TRACE_MASKT, "Start routed ");
            String[] routedParms = new String[]{STARTROUTED};
            String commandResults = this.executeScript(routedParms);
            Trace.trace(TRACE_MASKF, "results of STARTROUTED = [" + commandResults + "]");
        } else {
            Trace.trace(TRACE_MASKT, "Do not start routed ");
        }
    }

    public void networkRestart() {
        Trace.trace(TRACE_MASKD, "-> NetworkSettings.networkRestart(); someLanIsADHCPServer = " + this.someLanIsADHCPServer);
        String[] lanParms = new String[this.numLans * 3 + 1];
        lanParms[0] = IFRESET;
        int i = 1;
        if (this.numLans > 0) {
            int j = 0;
            while (j < this.numLans) {
                lanParms[i] = this.devName[j];
                lanParms[i + 1] = String.valueOf(this.dhcpClient[j]);
                lanParms[i + 2] = this.ipAddr[j];
                Trace.trace(TRACE_MASKF, "lanParms: " + lanParms[i] + ", " + lanParms[i + 1] + ", " + lanParms[i + 2]);
                i += 3;
                ++j;
            }
        }
        if (this.someLanIsADHCPServer) {
            this.determineNetworkSettings();
        }
        Trace.trace(TRACE_MASKD, "<- NetworkSettings.networkRestart()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ifconfigResults = "";
        allFileContents = "";
        networkFileResults = "";
        staticRoutesFileResults = "";
        routedFileResults = "";
        ethernetConfigFileResults = "";
        dnsFileResults = "";
        hostsFileResults = "";
        hostNameResults = "";
        dhcpdConfResults = "";
        persistKey = (class$com$ibm$hwmca$base$settings$network$NetworkSettings == null ? (class$com$ibm$hwmca$base$settings$network$NetworkSettings = NetworkSettings.class$("com.ibm.hwmca.base.settings.network.NetworkSettings")) : class$com$ibm$hwmca$base$settings$network$NetworkSettings).getName();
        SPEEDS = null;
        networkSettings = new NetworkSettings();
        _logInfo = new FrameworkClassLogInfo(85, "NetworkSettings");
    }
}

